#! /usr/bin/env python
#
# Log.py : -
#
#  Log file class to handle pretty wiriting to log
#
#

import time
import sys
import os

class Log:

    def __init__ ( self, log ) :
        self . log = log 
        self . _indentLevel = 0
        self . timers = []
        self . filter = ""
        self . filterOnOff = 0
        self . split = 0

    def setFilter ( self, x ) :
        self . filter = x

    def filterOn ( self ) :
        self . filterOnOff = 1

    def filterOff ( self ) :
        self . filterOnOff = 0

    def indentLevel ( self, newIndent=None  ):
        if newIndent:
            self . indent = newIndent
        return newIndent

    def indent ( self ) :
        self . _indentLevel = self . _indentLevel + 1

    def unindent ( self ):
        self . _indentLevel = self . _indentLevel - 1

    def write ( self, s ):
        filterString = ""
        if self . filterOnOff:
            filterString = self . filter + " "
        indentString = ""
        for i in range ( self . _indentLevel ) :
            indentString = indentString + " "

        self . log . write ( filterString + indentString ) 
        self . log . write ( s )
        self . log . flush ( ) 
        if self . split :
            sys . stdout . write ( filterString + indentString ) 
            sys . stdout . write ( s )
            sys . stdout . flush ( ) 
            
    def close ( self ) :
        self . log . close ( ) 

    def flush ( self ) :
        self . log . flush ( ) 

    def now ( self ):
        return time . asctime()
    
    def mark ( self ) :
        self . write ( self . now() + '\n' )

    def startTimer ( self ) :
        # NOTE : returns timer index to
        # allow reentrant calling of stopTimer ( 
        startTime = time . time ( )
        self . timers . append ( startTime )
        timeString = "-"
        for i in range ( self . _indentLevel ) :
            timeString = timeString + "-"
        timeString = timeString + "*> begin " + self . now( ) + '\n'
        self . write ( timeString )
        return len ( self . timers ) - 1

    def stopTimer ( self, index ) :
        endTime = time . time ( )
        startTime = self . timers [index ]
        timeString = "-"
        for i in range ( self . _indentLevel ) :
            timeString = timeString + "-"
        elapsedTime = int ( endTime - startTime )
        days = elapsedTime / ( 24 * 3600 )
        hours = ( elapsedTime - days * 24 * 3600 ) / 3600
        min = ( elapsedTime - days * 24 * 3600 - hours * 3600 ) / 60
        timeString = timeString  + "*> end   " + \
                     str ( elapsedTime ) + " " + \
                     self . now ( ) + ": elapsed [" + \
                     str ( days ) + " d " + \
                     str ( hours ) + " h " + \
                     str ( min ) + " m]\n\n" 
        self . write ( timeString )
	return elapsedTime
