#! /usr/bin/env python
#
# simple matrix class
#
#  NOTE: 3x3!!
#
import math


from FSUVector import Vector

class Matrix :

    def __init__(self, m = [] ):
            self.m = []
	    self . rows = 3
	    self . cols = 3
            if type(m) <> type([]):
               raise TypeError
	    if ( len ( m ) > 0 and ( len ( m ) != rows * cols ) ) :
		raise ValueError,  "Matrix::__init__(): invalid rows/cols"
            self.m = m[:]
	    if not len ( self . m ) :
		for i in range ( 9 )  :
		    self . m . append ( 0. )
		self . setItem ( 0, 0, 1. ) 
		self . setItem ( 1, 1, 1. ) 
		self . setItem ( 2, 2, 1. )
	
    def getItem ( self, i ,j  ) :
	    return self . m [ i * self . rows + j ]

    def setItem ( self, i, j, value ) :
	    self . m [ i * self. rows + j ] = value
	
    def getRow ( self, i ) :
	   if ( i >= self . rows ) :
		raise ValueError, "Matrix::getRow(): invalid row"
	   return ( Vector ( self . m [ i * self . rows ], \
			self . m [ i * self . rows + 1 ], \
			self . m [ i * self . rows + 2 ] ) )

    def getCol ( self, i ) :
        if ( i >= self . cols ) :
            raise ValueError, "Matrix::getCol(): invalid col"
        return ( Vector ( self . m [ i ], \
                          self . m [ self . rows + i ], \
                          self . m [ 2 * self . rows + i ] ) )

    def transpose ( self ) :
        r0 = self . getRow ( 0 )
        r1 = self . getRow ( 1 )
        r2 = self . getRow ( 2 )
        self . setCol ( 0, r0 )
        self . setCol ( 1, r1 )
        self . setCol ( 2, r2 )

    def setRow ( self, i, v ) :
	   if ( i >= self . rows ) :
		raise ValueError, "Matrix::setRow(): invalid row"
	   self . m [ i * self . rows ] = v [ 0 ] 
	   self . m [ i * self . rows + 1 ] = v [ 1 ] 
	   self . m [ i * self . rows + 2 ] = v [ 2 ]

    def setCol ( self, i, v ) :
	   if ( i >= self . rows ) :
		raise ValueError, "Matrix::setRow(): invalid row"
	   self . m [ i ] = v [ 0 ] 
	   self . m [ self . rows + i ] = v [ 1 ] 
	   self . m [ 2 * self . rows + i ] = v [ 2 ]

	 	
    def __repr__(self):	
	   s = repr ( self . getRow ( 0 ) ) + "\n"
	   s = s + repr ( self . getRow ( 1 ) ) + "\n"
	   s = s + repr ( self . getRow ( 2 ) ) 
	   return s

    def mult ( self, n ) :
	   # note this returns the 
	   # the matrix  M * N
	   m0 = self . getRow ( 0 )
	   m1 = self . getRow ( 1 )
	   m2 = self . getRow ( 2 )	
	   n0 = n . getCol ( 0 )
	   n1 = n . getCol ( 1 )
	   n2 = n . getCol ( 2 )
	   mn = Matrix ( ) 
	   mn . setRow ( 0, Vector ( \
		m0 . dot ( n0 ) , \
		m0 . dot ( n1 ) , \
		m0 . dot ( n2 ) ) )
	   mn . setRow ( 1, Vector ( \
	        m1 . dot ( n0 ) , \
		m1 . dot ( n1 ) , \
		m1 . dot ( n2 ) ) )
	   mn . setRow ( 2, Vector ( \
	        m2 . dot ( n0 ) , \
		m2 . dot ( n1 ) , \
		m2 . dot ( n2 ) ) )
	   return mn

    def setIdentity ( self ) :
	self . setItem ( 0, 0, 1.0 )
	self . setItem ( 0, 1, 0.0 )
	self . setItem ( 0, 2, 0.0 ) 
	self . setItem ( 1, 0, 0.0 )
	self . setItem ( 1, 1, 1.0 )
	self . setItem ( 1, 2, 0.0 ) 
	self . setItem ( 2, 0, 0.0 )
	self . setItem ( 2, 1, 0.0 )
	self . setItem ( 2, 2, 1.0 ) 


    def setRotX ( self, angleRad ) :
	self . setItem ( 0, 0, 1.0 )
	self . setItem ( 0, 1, 0.0 )
	self . setItem ( 0, 2, 0.0 ) 
	self . setItem ( 1, 0, 0.0 )
	self . setItem ( 1, 1, math . cos ( angleRad ) )
	self . setItem ( 1, 2, -math . sin ( angleRad ) )	
	self . setItem ( 2, 0, 0.0 )
	self . setItem ( 2, 1, math . sin ( angleRad ) )
	self . setItem ( 2, 2, math . cos ( angleRad ) )
        self . cleanup ( ) 

    def setRotY ( self, angleRad ) :
	self . setItem ( 0, 0, math . cos ( angleRad ) )
	self . setItem ( 0, 1, 0.0 )
	self . setItem ( 0, 2, math . sin ( angleRad ) ) 
	self . setItem ( 1, 0, 0.0 )
	self . setItem ( 1, 1, 1.0 )
	self . setItem ( 1, 2, 0.0 )	
	self . setItem ( 2, 0, -math . sin ( angleRad ) )
	self . setItem ( 2, 1, 0.0 )
	self . setItem ( 2, 2, math . cos ( angleRad ) )
        self . cleanup ( ) 

    def setRotZ ( self, angleRad ) :
	self . setItem ( 0, 0, math . cos ( angleRad ) )
	self . setItem ( 0, 1, -math . sin ( angleRad ) )
	self . setItem ( 0, 2, 0.0 ) 
	self . setItem ( 1, 0, math . sin ( angleRad ) )
	self . setItem ( 1, 1, math . cos ( angleRad ) )
	self . setItem ( 1, 2, 0.0 )	
	self . setItem ( 2, 0, 0.0 )
	self . setItem ( 2, 1, 0.0 )
	self . setItem ( 2, 2, 1.0 )
        self . cleanup ( ) 

    def setRotVector ( self, angleRad, rotVec ) :
	rx = rotVec [ 0 ]
	ry = rotVec [ 1 ]
	rz = rotVec [ 2 ]
	omc = 1. - math . cos ( angleRad )
	self . setItem ( 0, 0, math . cos ( angleRad ) + omc * rx *rx )
	self . setItem ( 0, 1, omc * rx * ry - rz * math . sin ( angleRad ) )
	self . setItem ( 0, 2, omc * rx * rz + ry * math . sin ( angleRad ) )
	self . setItem ( 1, 0, omc * rx * ry + rz * math . sin ( angleRad ) )
	self . setItem ( 1, 1, math . cos ( angleRad ) + omc * ry * ry )
	self . setItem ( 1, 2, omc * ry * rz - rx * math . sin ( angleRad ) )
	self . setItem ( 2, 0, omc * rx * rz - ry * math . sin ( angleRad ) )
	self . setItem ( 2, 1, omc * ry * rz + rx * math . sin ( angleRad ) )
	self . setItem ( 2, 2, math . cos ( angleRad ) + omc * rz * rz )

    def preMultColVec ( self, vec ) :
	m0 = self . getRow ( 0 ) 
	m1 = self . getRow ( 1 ) 
	m2 = self . getRow ( 2 ) 
	return ( Vector ( \
		m0 . dot ( vec ) , \
		m1 . dot ( vec ) , \
		m2 . dot ( vec ) ) ) 
	
    def postMultRowVec ( self, vec ) :
	m0 = self . getCol ( 0 ) 
	m1 = self . getCol ( 1 ) 
	m2 = self . getCol ( 2 ) 
	return ( Vector ( \
	   m0 . dot ( vec ), 
	   m1 . dot ( vec ),
	   m2 . dot ( vec ) ) )
	
    def cleanup ( self ) :
        # get rid of nasty floating point non-zero slop
        for i in range ( len ( self . m ) ):
            if ( math .fabs ( self . m [ i ])  < 0.0001 ) :
                self . m [ i ] = 0.

