#! /usr/bin/env python
#
# Utils.py : - various utils - primarily for running
#               other programs from within a script
#
#

import sys
import os
import re
import math
import string

class Utils:

    def __init__ ( self ) :
       
        self . cpCommand = "/bin/cp"
        self . mvCommand = "/bin/mv"
        self . catCommand = "/bin/cat"

    def makedirs(self, p, clean=0 ):
        if p and not os.path.isdir(p):
            head, tail = os.path.split(p)
            self.makedirs(head)
            os.mkdir(p, 0777)
        if clean:
            # remove any files which may be there
            files = os . listdir ( p )
            for f in files:
                fileName =  p + "/" + f
                if not os . path. isdir ( fileName ) :
                    os . unlink ( fileName )

    def firstChar (self, line ) :
        i = 0
        while line [i ] == ' ':
            i = i + 1
        return line[i]
        
    def fileExists (self, filePath, debug=0 ) :
	if debug or os . path . exists ( filePath ) :
	    return 1
	else:
	    return 0

    def ctrlCHandler(self, *whatever):
        print "Interrupt caught. Exiting..."
        sys . exit ( -1 )

    def getStats ( self, data ) :
	if not len ( data ):
		return ( -1, -1, -1, -1 )
        minData = 9999999999.;
        maxData = -9999999999.;
        total = 0.0
        for item in data:
                if ( item > maxData ) :
                        maxData = item
                if ( item < minData ) :
                        minData = item
                total = total + item
        average = total / len ( data )
        sd = 0.
        for item in data:
                var = ( item - average ) *  ( item - average )
                sd = sd + var

        sd = sd / len ( data )
        sd = math . sqrt ( sd )
	return ( average, sd, minData, maxData )

    def runit ( self, command, verbose = 0 , debug = 0, out=sys.stdout ) :
        if verbose and out:
            out . write ( command + '\n' )
            out . flush () 
        if not debug :
            p = os. popen ( command, 'r' )
            text = "command output"
            while ( text ):
                text = p . readline ( )
                out.write( text )
                out.flush()
            sts = p.close()
        if verbose and out:
            out . flush()

    def pad5 ( self, i ) :
        # return a 5 zero-padded number string
        if i < 10 :
            return "0000" + str ( i )
        elif i < 100:
            return "000" + str ( i )
        elif i < 1000:
            return "00" + str ( i )
        elif i < 10000:
            return "0" + str ( i )
        elif i < 100000:
            return str ( i )
        else:
            print "Error: mutils.pad5() number too big! ", i
            return "-1"
