import os, math, string, sys

class Vector:

    def __init__(self, x, y, z ):
		self._x = float ( x )
		self._y = float ( y )
		self._z = float ( z )
 
    def __str__(self):
	return '(' + str ( self._x ) + \
		',' + str ( self._y ) + \
		',' + str ( self._z ) + ')'

    __repr__ = __str__

    def  __setitem__(self, item, value) :
	if item == 0 : 
	   self._x = value
	if item == 1 :
	   self._y = value
  	if item == 2 :
	   self._z = value

    def  __getitem__(self, item) :
	if item == 0 : 
	   return self._x
	if item == 1 :
	   return self._y
  	if item == 2 :
	   return self._z

    def x( self ):
        return self . _x
    def y( self ):
        return self . _y
    def z( self ):
        return self . _z

    def dot ( self, b ) :
        dotProduct =  self . _x  *  b . _x  + \
                     self . _y *  b . _y  + \
                     self . _z *  b . _z 
        return dotProduct

    def normalize ( self ) :
        length = self .length ( ) 
        self . scale ( 1. / length )
        
    def length ( self ) :
        return math . sqrt ( self . _x * self . _x + \
                             self . _y * self . _y + \
                             self . _z * self . _z ) 

    def __rmul__ ( self, value ) :
        return (  Vector ( self. _x * value , \
                           self. _y * value , \
                           self. _z * value ) )

    def scale ( self, x ):
         self . _x  = self . _x * x
         self . _y  = self . _y * x
         self . _z  = self . _z * x

    def cross ( self, b ) :
        i = self . _y * b . _z - self . _z * b . _y
        j = self . _x * b . _z - self . _z * b . _x
        k = self . _x * b . _y - self . _y * b . _x	
        return Vector ( i, -j, k )

    def __add__ ( self, b ) :
        return self . add ( b )
    
    def __sub__ ( self, b ) :
        return self . subtract ( b ) 

    def subtract ( self, b ) :
        return Vector ( self. _x - b . _x , \
                        self. _y - b . _y , \
                        self. _z - b . _z )
    def add ( self, b ) :
        return Vector ( self. _x + b . _x , \
                        self. _y + b . _y , \
                        self. _z + b . _z )

    def cleanup ( self ) :
        # get rid of nasty floating point non-zero slop
        if ( math .fabs ( self . _x )  < 0.0001 ) :
            self . _x = 0.
        if ( math .fabs ( self . _y ) < 0.0001 ) :
            self . _y = 0.
        if ( math .fabs ( self . _z ) < 0.0001 ) :
            self . _z = 0.





