#! /usr/bin/env python
#
# FSUXUtils.py :
#
#   XPLOR-NIH utility programs
#   mainly encapsulations of ugly XPLOR commands
#
#

import xplorNIH
import xplor
import sys

class XUtils:

    def __init__ ( s ) :
        pass

    
    def loadData ( s, pdb, psf ) :
        loadString = r"""
        topology @TOPPAR:topallhdg_new.pro end
        parameter @TOPPAR:parallhdg_new.pro  end
        structure @%s end
        coordinates @%s
        """ % ( psf, pdb )
        xplor . command ( loadString )

    def setNonBondedParams ( s, **kw ):
        paramString = r"""
        parameter
        nbonds """;
        for k in kw.keys():
            if ( k[:4] == "cutn" or
                 k[:4] == "tole" or
                 k[:4] == "wmin" or 
                 k[:4] == "inhi" or
                 k[:4] == "spec" or
                 k == "ctofnb" or
                 k == "ctonnb" or
                 k[:4] == "bshf" or
                 k == "eps" or 
                 k[:4] == "e14f" or
                 k[:4] == "repe" or
                 k[:4] == "rexp" or
                 k[:4] == "irex" or
                 k[:4] == "rcon" or
                 k[:4] == "ratt" or
                 k[:4] == "dept" or
                 k[:4] == "nbxm" ) :
                addParam = k + "=" + str (kw[k]) + " "
            elif ( k[:4] == "grou" or
                   k[:4] == "atom" or
                   k[:4] == "trun" or
                   k[:4] == "swit" or
                   k[:4] == "shif" or
                   k[:4] == "cdie" or
                   k[:4] == "rdie" or
                   k[:4] == "vswi" ) :
                addParam = k + " "
            else:
                print "Error! - unknown non-bonded keyword : " , k
                sys . exit ( -1 )
            paramString = paramString + addParam + '\n'
        paramString = paramString + r"""
        end
        end"""
        print paramString
        xplor . command ( paramString )
        
    def setVerbose ( s, verbose = 1 ) :
        if verbose == 0:
            vString = "none"
        if verbose == 1:
            vString = "all"
        xplor . command ( "set message=%s end" % vString )

    def addHydrogens ( s ) :
        # hbuild works better if non-bonded interactions are turned off
        hString = r"""
        flags exclude vdw elec end
        vector do (mass=1.0) (name h*)
        hbuild select=(name h*) phistep=360 end
        flags include vdw elec end"""
        xplor . command ( hString )

    def write ( s, pdb ) :
        xplor . command ( "write coords output=%s end" % pdb )

    def stop ( s ) :
        xplor . command ( "STOP" )
    def end ( s ) :
        xplor . command ( "END" )
        
        
