
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <math.h>

int main(int argc, char** argv)
{
	float f = M_PI; /* default value of pi? */
	int i = 1;
	int d; /* file number */
	int err = 0;

	for ( i = 1; i < argc; i++ )
	{
		if ( sscanf(argv[i], "%f", &f) < 0 )
		{
			printf("Skipping %s\n", argv[i]);
			err--;
			continue;
		}
		d = open(argv[i], O_WRONLY | O_CREAT, S_IRUSR | S_IRGRP | S_IROTH);
		if ( d < 0 )
		{
			printf("Skipping %s f = %f\n", argv[i], f);
			err--;
			continue;
		}
		if ( write(d, (char*)&f, sizeof(f) ) != sizeof(f) )
		{
			printf("write error f = %f\n", f);
			err--;
		}
		close(d);
	}
	return err;
}
