function n = f(x1, x2, v1, v2, h, jmax, L)
% this is a script file that generates the geodesic that starts at
% (x1, x2, fun(x1,x2)) in the direction (v1, v2, ?) on the tangent plane
% using steps of size h, until we step outside -L <=x,y,z<=L or
% exceed jmax steps

%first point
q = [x1, x2, fun(x1,x2)];

%initialize geodesic
x = [q(1)];
y = [q(2)];
z = [q(3)];

glen = 0;
gvals = [];

%initialize normal vector
n = [funx(q(1), q(2)), funy(q(1),q(2)), -1];

%initialize tangent vector
% solves n1*v1+n2*v2-1*v3=0
v = [v1, v2, n(1)*v1+n(2)*v2];
%normalize to length h
tn = h*v/norm(v);

%move in the tangent plane
r = q + tn;

j = 0;
while j < jmax & abs(q(1)) <= L & abs(q(2)) <= L
	% project back to z = fun(x,y) using newton's method on f(t)
	k = 0;
	t = 0;
	eps = 1;
	tvals = t;
	nmax = 25;

	while eps >= 1e-5 & k <= nmax
		rp = r + t.*n;
		fp = [funx(rp(1),rp(2)), funy(rp(1),rp(2)), -1]*n';
		s = t - (fun(rp(1),rp(2))-(rp(3)-t))/ fp;
		tvals = [tvals, t];
		eps = abs(s-t);
		t = s; k = k + 1;
	end

	% the second point
	p = r + t.*n;

	tmp = norm(p-q);
	glen = glen + tmp;
	gvals = [gvals, tmp];

	x = [x p(1)];
	y = [y p(2)];
	z = [z p(3)];

	r = q; q = p; j = j + 1;
	n = [funx(q(1), q(2)), funy(q(1),q(2)), -1];

	% 
	u = (q-r)*n'/(n*n');
	r = r + u.*n;
	v = q-r;
	tn = h* v/norm(v);
	r = q + tn;
end

plot3(x, y, z,'-mo', ...
	'LineWidth',3, ...
	'MarkerEdgeColor','k', ...
	'MarkerFaceColor',[.49 1 .63], ...
	'MarkerSize',10)

%n = glen/j;
n = gvals;
