static char SccsId[] = "@(#)gen.c	1.1 06/24/97 polymer";

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <tcl.h>
#include <tk.h>
#include <togl.h>
#include "polymerl.h"
#define min(a,b) ((a)<(b) ? (a):(b))

extern struct PLargs arg;
extern float *x, *y, *z;

/*********************************************************/
/*make_new_chain_cubic:
  generate polymer chains on a cubic lattice
  type = 1 --- generating a chain in the morphous region
       = 0 --- generating an arbitray single chain
  					    		 */
/*********************************************************/
void
make_new_chain_cubic (int doubleside, int type, int* side, int* length)
{
  int dx, dy, dz;
  int i;
  int pre_state = 1;

  y[0] = arg.y_init;
  z[0] = arg.z_init;

  y[1] = y[0];
  z[1] = z[0];

  if (doubleside) { /* side M */
     x[0] = arg.M;
     x[1] = x[0] - 1;
  }
  else {  	    /* side 0 */
     x[0] = arg.x_init;
     x[1] = x[0] + 1;
  }

  *side = 0;
  if (arg.M > 1) {
     *length = arg.max_length;

     for (i = 2; i <= *length; i++) {
        step_cubic (&dx, &dy, &dz, &pre_state);
        x[i] = x[i-1]+dx;
        y[i] = y[i-1]+dy;
        z[i] = z[i-1]+dz;

        if (type == 0)
           ;                                 /* single chain */
        else {
           if (x[i] >= arg.M-0.1) {          /* terminates at M */
              if (doubleside)
                 *side = 1;                  /* starting from M; loop formed */
              else
                 *side = 2;                  /* starting from 0; tie formed */ 
           } else if (x[i] <= 0.1) {         /* terminates at 0 */
              if (doubleside)
                 *side = 2;                  /* starting from M; tie formed */
              else
                 *side = 1;                  /* starting from 0; loop formed */
           }
           if (type > 1 &&                   /* amorphous region + clip */
               (y[i] > arg.Y+0.1 || 
                y[i] <= -arg.Y+0.1 || 
                abs(z[i]) >= arg.Z-0.1))
              *side = 8;
        }
        if ( *side ) {
           *length = i;
           break; 
        }
     }
  }
  else 
     *length = min(arg.M, arg.max_length);

  if (type && !*side)
     *side = 4;

  return;
} /* make_new_chain_cubic */


/********************************************/
/*step_cubic:
  get the next position of the chain	    */
/********************************************/
void step_cubic(int *dx, int *dy, int *dz, int *pre_state)
{
    float rn;

    rn = randfloat();

    *dx = *dy = *dz = 0;

    if (rn <= 0.2) {
       if (abs(*pre_state) == 1)
          *dx = *pre_state;
       else if (abs(*pre_state) == 2)
          *dy = *pre_state/2;
       else
          *dz = *pre_state/3;
    }
    else if (rn <= 0.4) {
       if (abs(*pre_state) != 1)
          *dx = 1;
       else
          *dy = 1;
    }
    else if (rn <= 0.6) {
       if (abs(*pre_state) != 1)
          *dx = -1;
       else
          *dy = -1;
    }
    else if (rn <= 0.8) {
       if (abs(*pre_state) != 3)
          *dz = 1;
       else
          *dy = 1;
    }
    else {
       if (abs(*pre_state) != 3)
          *dz = -1;
       else
          *dy = -1;
    }
    *pre_state = (*dx) + 2*(*dy) + 3*(*dz);

} /* step_cubic */


/********************************************/
/*randfloat:
  get one random number between 0 and 1
                                            */
/********************************************/
float randfloat()
{
	int r =rand();
	float rn;

	if (r < 0) r = -r;
	rn =  (float) r/(float) RAND_MAX;

	return rn;
} /* randfloat */


/********************************************/
/*make_new_chain_diamond:
  generate polymer chains on a diamond lattice
  type = 1 --- generating a chain in the morphous region
       = 0 --- generating an arbitray single chain
/********************************************/
void
make_new_chain_diamond (int doubleside, int type, int* side, int* length)
{
    int i, u[4], v[4], dx, dy, dz;
    float pt, pg;

    /**************************************
        side = 0 --- single chain 
        side = 1 --- loop 
        side = 2 --- tie 
        side = 4 --- free end 
        side = 8 --- terminated at sides 
    ***************************************/
    *side = 0;

    pre_probability(&pt, &pg);

    y[0] = 1 + arg.y_init;
    z[0] = 0 + arg.z_init;

    y[1] = 0 + arg.y_init;
    z[1] = 0 + arg.z_init;

    y[2] = 1 + arg.y_init;
    z[2] = 0 + arg.z_init;

    if (doubleside) { /* crystal M */
       x[0] = 1 + arg.M;
       x[1] = 0 + arg.M;
       x[2] = -1 + arg.M;
    }
    else {            /* crystal 0 */
       x[0] = -1 + arg.x_init;
       x[1] = 0 + arg.x_init;
       x[2] = 1 + arg.x_init;
    }
    if ( arg.M > 1 ) {
       *length = arg.max_length;
       for(i = 3; i <= *length+1; i++) {

           u[1] = x[i-1] - x[i-2];
           u[2] = y[i-1] - y[i-2];
           u[3] = z[i-1] - z[i-2];

           v[1] = x[i-2] - x[i-3];
           v[2] = y[i-2] - y[i-3];
           v[3] = z[i-2] - z[i-3];

           /*  position of the next C */
           delta(&dx, &dy, &dz, u, v, pt, pg);
 
           x[i] = x[i-1] + dx;
           y[i] = y[i-1] + dy;
           z[i] = z[i-1] + dz;

           if (type == 0)
              ; 				/* single chain */
           else {
              if (x[i] >= arg.M-0.1) { 		/* terminates at M */
		 if (doubleside)
                    *side = 1;  		/* starting from M; loop formed */
	         else
                    *side = 2;  		/* starting from 0; tie formed */
              } else if (x[i] <= 0.1) { 	/* terminates at 0 */
                 if (doubleside)
                    *side = 2;  		/* starting from M; tie formed */
                 else
                    *side = 1;  		/* starting from 0; loop formed */ 
              }
  	      if (type > 1 && 		        /* amorphous region + clip */
		    (y[i] > arg.Y+0.1 || 
		     y[i] <= -arg.Y+0.1 || 
		     abs(z[i]) >= arg.Z-0.1) )
	         *side = 8;  			/* cliped at sides */
           }
           if ( *side ) {
              *length = i-1;
	      break; 
           }
       }
    }
    else 
       *length = min(arg.M, arg.max_length);

    if (type && !*side)
       *side = 4;

    /*  get back to normal length ratio x/y, z/y = sqrt2 */
    for (i = 0; i <= *length; i++) {
   	x[i] = x[i+1]*sqrt(2.0);
	y[i] = y[i+1];
	z[i] = z[i+1]*sqrt(2.0);
    }
    

}
/********************************************/
/* delta:
      get the position of a chain on a 
      diamond lattice			    */			 
/********************************************/
void 
delta(int* dx, int* dy, int* dz, int* u, int* v, float pt, float pg)
{ 
   float rn;
   int w[4];	

   cross(u,v,w);

   rn = randfloat();   

   if (rn < pt) {			/* t  */
     *dx = v[1];
     *dy = v[2];
     *dz = v[3];
   }
   else {
     if (rn < pt+pg) { 			/* g-  */
        *dx = ssign(u[1]-v[1]-w[1]); 
        *dy = ssign(u[2]-v[2]-w[2]);
        *dz = ssign(u[3]-v[3]-w[3]);
     }
     else {				/* g+  */
        *dx = ssign(u[1]-v[1]+w[1]);
        *dy = ssign(u[2]-v[2]+w[2]);
        *dz = ssign(u[3]-v[3]+w[3]);
     }
  }
}
/********************************************/
/* ssign:
        sign function for integer x         */
/********************************************/
int 
ssign(int x) 
{			 
  if (x > 0) 
     return 1;
  else {
     if (x < 0) 
       return -1;
     else
       return 0;
  }
}
/********************************************/
/* cross:
        cross product of u and v	    */
/********************************************/
void 
cross(int* u, int* v, int* w)
{
/*finding cross product of u and v, save it in w*/
	w[1] = u[2]*v[3]-u[3]*v[2];
	w[2] = u[3]*v[1]-u[1]*v[3];
	w[3] = u[1]*v[2]-u[2]*v[1];
}
/********************************************/
/* pre_probability:
      calculate the probabilities of trans,
      gauche+ and gauche- to occur          */
/********************************************/
void 
pre_probability(float *pt, float *pg)
{
   float  a, w, R = 2.0;
        
   if (arg.temperature > 10000) {
     *pt = 0.33333333;
     *pg = 0.33333333;
   }
   else if (arg.temperature < 1) {
     *pt = 1.0;
     *pg = 0.0;
   } else {
     a = exp(-(430+590)/(2*R*arg.temperature));
     w = exp(-(1700+2000)/(2*R*arg.temperature));
     *pt = (1+2*a)/(1+4*a+2*a*a+2*a*a*w);
     *pg = (1-*pt)/2;
   }
}

