/*    PolymerLibV1.0 - the PolymerGenerator 
**
**    Copyright (C) 1997 Steven Bellenot & Zhong-Hui Duan(zduan@math.fsu.edu)
**
**    This software is shareware!
*/

#pragma ident "@(#)polymerl.h	1.1 06/24/97 polymer"

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <GL/gl.h>
#include <GL/glu.h>

#ifndef Cubic
   #define Cubic    0
#endif
#ifndef Diamond
   #define Diamond  1
#endif

/* structs */
struct PLargs
{ 
  int mode;
  int type;
  int ch2; /* show hydrogens */
  int lattice;

  int temperature;
  int seed; 
  int max_length;
  int M; /* thickness of liquid-like region */
  int Y; /* length of the square */
  int Z; /* width of the square */
  int D;

  float x_init, y_init, z_init;

};

/* maximum points on the top of a cylinder */
#define max_pts 17
#define radius 0.1

struct cylinder
{
   float topx[max_pts];
   float topy[max_pts];
   float topz[max_pts];
   float downx[max_pts];
   float downy[max_pts];
   float downz[max_pts];
};
 
/* prototypes */

void    error(char *);
void    diff3(GLdouble [3], GLdouble [3], GLdouble [3]);
void    add3(GLdouble [3], GLdouble [3], GLdouble [3]);
void    scalarmult(GLdouble, GLdouble [3], GLdouble [3]);
GLdouble        dot3(GLdouble [3], GLdouble [3]);
GLdouble        length3(GLdouble [3]);
GLdouble        dist3(GLdouble [3], GLdouble [3]);
void    copy3(GLdouble [3], GLdouble [3]);
void    crossprod(GLdouble [3], GLdouble [3], GLdouble [3]);
void    normalize(GLdouble [3]);
void    print3(GLdouble [3]);
 
void dodecahedron(GLdouble [3], GLdouble, GLenum);
void mycylinder(GLdouble [3], GLdouble, GLint , GLdouble [3], GLenum);
void Points(float, struct cylinder*, int, GLdouble [3], GLdouble [3]);
void myquad (GLdouble [3], GLdouble [3], GLdouble [3], GLdouble [3],
                GLdouble [3], GLenum);
 
void  resetpara(void);
void  drawpolymerchain (void);
void  drawpolymerframes (void);
void  drawpolymerbonds (void);
void  drawamorphous_region (int, int, int, int, int);
int   min(int, int);
void  make_new_chain_cubic (int, int, int*, int*);
void  make_new_chain_diamond (int, int, int*, int*);
void  step_cubic (int*, int*, int*, int*);
void  step_diamond (int*, int*, int*, int*);

void  dodecahedron(GLdouble *, GLdouble, GLenum);

void  pre_probability (float*, float*);
void  delta (int*, int*, int*, int*, int*, float, float);
void  cross (int*, int*, int*);
int   ssign (int);

float randfloat(void);

void ReadInfile (struct PLargs *arg, FILE *fp);
void WriteRAWFile (struct PLargs arg, FILE *fp);
void WriteWRLFile (int, int, int, FILE *fp);
void WriteWRL3DFile (int, int, int, FILE *fp);
void WriteWavefrontFile (int, int, int, FILE *fp);

void drawDodecahedron(int length, float, FILE *fp);
void DodecahedronWRL(GLdouble [3], GLdouble, FILE *fp);
void drawCylinder(int length, FILE *fp, float);
void points(float, struct cylinder*, int, GLdouble [3], GLdouble [3]);
void renderPlanes(FILE *fp);

void Hspace(int, float*, float*, float*, float*, float*, float*);
void drawH_line(int);
void get_Hs(int, float*, float*, float*, float*, float*, float*);
void get_next(int, int*);
int get_number(int*);
void get_vector(int, int*);
void render_end_Hs(int);
void get_End_Hs(int, GLdouble [3], GLdouble [3], GLdouble [3]);


