static char SccsId[] = "@(#)rdwrt.c	1.1 06/24/97 polymer";
/*
**    PolymerLibV1.0 - the PolymerGenerator 
**
**    This software is shareware!
*/

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "polymerl.h"

#define NORMAL      1

/* length for all strings */
#define LENGTH 256

 
extern float *x, *y, *z;
extern struct PLargs arg;


/********************************************/
/*ReadInfile:                               
  read values of parameters from file fp    */
/********************************************/
void
ReadInfile (struct PLargs *arg, FILE * fp)
{
  char readline[LENGTH], hilf[LENGTH], *hp;
  /* set some defaults */

  while (fgets (readline, LENGTH, fp) != NULL)
  {
      if(readline[0] != '#')
      {
         hp = strstr (readline, "lattice:");
         if (hp != NULL) 
	     arg->lattice = atoi (hp + 8);

         hp = strstr (readline, "type:");
         if (hp != NULL)
	     arg->type = atoi (hp+5);

         hp = strstr (readline, "temperature:");
         if (hp != NULL)
	     arg->temperature = atoi (hp+12);

         hp = strstr (readline, "seed:");
         if (hp != NULL)
	     arg->seed = atoi (hp+5);

         hp = strstr (readline, "max_length:");
         if (hp != NULL)
	     arg->max_length = atoi (hp+7);

         hp = strstr (readline, "regionL:");
         if (hp != NULL)
	     arg->M = atoi (hp+8);

         hp = strstr (readline, "regionH:");
         if (hp != NULL)
	     arg->Y = atoi (hp+8);

         hp = strstr (readline, "regionW:");
         if (hp != NULL)
	     arg->Z = atoi (hp+8);

         hp = strstr (readline, "density:");
         if (hp != NULL)
	     arg->D = atoi (hp+8);
      }
    }				/* while */

  return;
}				/* ReadInfile */


/********************************************/
/*WriteRAWFile:                             
  save values of parameters to file fp      */
/********************************************/
void
WriteRAWFile (struct PLargs arg, FILE *fp)
{
  fprintf (fp, "# Datafile for PolymerLib, the PolymerGenerator.\n");
  fprintf (fp, "# Generated by Polymer-Laboratory.\n");
 
  fprintf (fp, "lattice:%d\n", arg.lattice);
  fprintf (fp, "type:%d\n", arg.type);
  fprintf (fp, "temperature:%d\n", arg.temperature);
  fprintf (fp, "seed:%d\n", arg.seed);
  fprintf (fp, "max_length:%d\n", arg.max_length);
  fprintf (fp, "regionL:%d\n", arg.M);
  fprintf (fp, "regionH:%d\n", arg.Y);
  fprintf (fp, "regionW:%d\n", arg.Z);
  fprintf (fp, "density:%d\n", arg.D);

  return;
}				/* WriteRAWFile */

/********************************************/
/* renderPlanes:
       render Planes for .wrl file	    */
/********************************************/
void
renderPlanes(FILE *fp) 
{
   float x0, y0, z0;

   float NM = arg.M;
   float NY = arg.Y;
   float NZ = arg.Z;
   if (arg.lattice) {
      NM = NM*sqrt(2.0);
      NZ = NZ*sqrt(2.0);
   }
   fprintf(fp, "Separator {\n"); 

       fprintf(fp, "    Coordinate3 {\n");
         fprintf(fp, "\tpoint [\n");
 
	      x0 = 0.0; y0 = -1.0*NY; z0 = -1.0*NZ;
              fprintf(fp, "\t  %f %f %f,\n", x0, y0, z0);
	      y0 = 1.0*NY; 
              fprintf(fp, "\t  %f %f %f,\n", x0, y0, z0);
	      z0 = NZ;
              fprintf(fp, "\t  %f %f %f,\n", x0, y0, z0);
	      y0 = -1.0*NY;
              fprintf(fp, "\t  %f %f %f,\n", x0, y0, z0);
              x0 = NM; y0 = -NY; z0 = -NZ; 
              fprintf(fp, "\t  %f %f %f,\n", x0, y0, z0);
              y0 = NY; 
              fprintf(fp, "\t  %f %f %f,\n", x0, y0, z0);
              z0 = NZ;
              fprintf(fp, "\t  %f %f %f,\n", x0, y0, z0);
              y0 = -NY;
              fprintf(fp, "\t  %f %f %f,\n", x0, y0, z0);

         fprintf(fp, "\t]\n");
       fprintf(fp, "    }\n");
 
       fprintf(fp, "    IndexedLineSet {\n");
         fprintf(fp, "\tcoordIndex [\n");
              fprintf(fp, "\t %d, %d, %d, %d, %d, %d, \n", 0, 1, 2, 3, 0, -1);
              fprintf(fp, "\t %d, %d, %d, %d, %d", 4, 5, 6, 7, 4);
         fprintf(fp, "\n\t]\n");
       fprintf(fp, "    }\n");
 
   fprintf(fp, "}\n"); 
}
/*************************************************/
/*WriteWRLFile:                             
  save polymer graphics as a VRML file where
  C and C-C bonds are rendered as lines and dots */
/*************************************************/
void
WriteWRLFile (int in, int side, int length, FILE *fp)
{
   int i;

   fprintf(fp, "#VRML V1.0 ascii\n");
   fprintf(fp, "#A polyethylene chain!\n\n");

   if (in == 0)
       renderPlanes(fp);

   fprintf(fp, "Separator {\n");

     fprintf(fp, "  Separator {\n");
 
       fprintf(fp, "    Material {diffuseColor 1.0 0.0 0.0");
       fprintf(fp, "    }\n");
 
       fprintf(fp, "    Coordinate3 {\n");
         fprintf(fp, "\tpoint [\n");

	   for (i = 0; i <= length; i++)
	      fprintf(fp, "\t  %f %f %f,\n", x[i], y[i], z[i]);

         fprintf(fp, "\t]\n");
       fprintf(fp, "    }\n");
 
       fprintf(fp, "    PointSet {\n");
         fprintf(fp, "\tstartIndex 0\n");
         fprintf(fp, "\tnumPoints -1\n");
       fprintf(fp, "    }\n");
 
     fprintf(fp, "  }\n");
     fprintf(fp, "  Separator {\n");
 
       fprintf(fp, "    Material {diffuseColor 1.0 1.0 1.0");
       fprintf(fp, "    }\n");
 
       fprintf(fp, "    Coordinate3 {\n");
         fprintf(fp, "\tpoint [\n");
 
           for (i = 0; i <= length; i++)
              fprintf(fp, "\t  %f %f %f,\n", x[i], y[i], z[i]);
 
         fprintf(fp, "\t]\n");
       fprintf(fp, "    }\n");
 
       fprintf(fp, "    IndexedLineSet {\n");
         fprintf(fp, "\tcoordIndex [\n\t");
           for (i = 0; i <= length; i++) {
              fprintf(fp, " %d, ", i);
              if (i/10*10==i)
                 fprintf(fp, "\n");
           }
         fprintf(fp, "\n\t]\n");
       fprintf(fp, "    }\n");
 
     fprintf(fp, "  }\n");
   fprintf(fp, "}\n");
}


/*************************************************/
/*WriteWRL3DFile:                             
  save polymer graphics as a VRML file where
  C and C-C bonds are rendered as lines and dots */
/*************************************************/
void WriteWRL3DFile (int in, int side, int length, FILE *fp)
{
   float rd;

   fprintf(fp, "#VRML V1.0 ascii\n");
   fprintf(fp, "#A polyethylene chain!\n\n");
 

   fprintf(fp, "Separator {\n");

/* draw cylinders */ 

     rd = 0.1;
     fprintf(fp, " Separator {\n");
       drawCylinder(length, fp, rd);
     fprintf(fp, " }\n");

/* draw dodecahedrons */

     rd = 0.1;
     fprintf(fp, " Separator {\n");
       drawDodecahedron(length, rd, fp);
     fprintf(fp, " }\n");

   fprintf(fp, "}\n");
}

/* render C-C as cylinders */
void drawCylinder(int length, FILE *fp, float rd)
{
   int i, j;
   int pn = 6; /* pn must be an even number */
   void pointCylinder(int, FILE *fp, int pn, float rd);
   void normalCylinder(int, FILE *fp, int pn, float rd);

     fprintf(fp, "  Material {diffuseColor  0.6 0.6 0.6}\n");
     fprintf(fp, "  Coordinate3 {\n");
       fprintf(fp, "\tpoint [\n");
 
	  pointCylinder(length, fp, pn, rd);

       fprintf(fp, "\t]\n");
     fprintf(fp, "    }\n");

     fprintf(fp, "  Separator {\n");

       fprintf(fp, "\tNormal {\n");
       fprintf(fp, "\t   vector [\n");

	  normalCylinder(length, fp, pn, rd);
 
       fprintf(fp, "\t   ]\n");
       fprintf(fp, "\t}\n");

       fprintf(fp, "\tIndexedFaceSet {\n");
         fprintf(fp, "\t  coordIndex [\n");

         for (i = 0; i<length; i++) {
                for (j = 2; j < 2*pn; j+=2) 
                  fprintf(fp, "\t  %d,%d,%d,%d,-1,\n",
			      i*2*pn+j-2,i*2*pn+j-1,i*2*pn+j+1,i*2*pn+j); 
               
                fprintf(fp, "\t  %d,%d,%d,%d,-1,\n",
		              (i+1)*2*pn-2,(i+1)*2*pn-1,i*2*pn+1,i*2*pn); 
         }
 
         fprintf(fp, "\t  ]\n");

	 fprintf(fp, "\t  normalIndex [\n");

         for (i = 0; i<length; i++) {
                for (j = 2; j < 2*pn; j+=2) 
                  fprintf(fp, "\t  %d,%d,%d,%d,-1,\n",
			      i*2*pn+j-2,i*2*pn+j-1,i*2*pn+j+1,i*2*pn+j); 
               
                fprintf(fp, "\t  %d,%d,%d,%d,-1,\n",
		              (i+1)*2*pn-2,(i+1)*2*pn-1,i*2*pn+1,i*2*pn); 
         }
 
         fprintf(fp, "\t  ]\n");

       fprintf(fp, "\t}\n");
 
     fprintf(fp, "  }\n");
}

void pointCylinder(int length, FILE *fp, int pn, float rd)
{
   int i, j;
   GLdouble cpt[3], a[3];
   struct cylinder pts;

   for (i = 0; i<length; i++) {
      cpt[0] = x[i];
      cpt[1] = y[i];
      cpt[2] = z[i];
      a[0] = x[i+1] - x[i];
      a[1] = y[i+1] - y[i];
      a[2] = z[i+1] - z[i];
      points(rd, &pts, pn, cpt, a);
      for (j = 0; j < pn; j++) {
         fprintf(fp, "\t  %f %f %f,\n",
		pts.topx[j], pts.topy[j], pts.topz[j]); 
         fprintf(fp, "\t  %f %f %f,\n",
		pts.downx[j], pts.downy[j], pts.downz[j]); 
      }
   }
}

void normalCylinder(int length, FILE *fp, int pn, float rd)
{
   int i, j;

   GLdouble cpt[3], a[3], n[3];
   struct cylinder pts;

    for (i = 0; i<length; i++) {
       cpt[0] = x[i];
       cpt[1] = y[i];
       cpt[2] = z[i];
       a[0] = x[i+1] - x[i];
       a[1] = y[i+1] - y[i];
       a[2] = z[i+1] - z[i];
       points(rd, &pts, pn, cpt, a);
       for (j = 0; j < pn; j++) {

          n[0] = x[i] - pts.topx[j];
          n[1] = y[i] - pts.topy[j];
          n[2] = z[i] - pts.topz[j];

	  normalize(n);

          fprintf(fp, "\t  %f %f %f,\n", n[0], n[1], n[2]);

          n[0] = x[i+1] - pts.downx[j];
          n[1] = y[i+1] - pts.downy[j];
          n[2] = z[i+1] - pts.downz[j];

	  normalize(n);

          fprintf(fp, "\t  %f %f %f,\n", n[0], n[1], n[2]);

        }
    }
}

void points(float rd, struct cylinder* pts, 
	                    int pn, GLdouble cpt[3], GLdouble a[3])
{
   int i; 
   GLdouble b[3], w[3];
   float alpha;

   if (pn > max_pts) {
      fprintf(stderr, "too many points!\n");
      exit (1);
   }
   if (abs(a[0]*a[1]*a[2]) > 0.0001) {
      b[0] = 0;
      b[1] = a[2];
      b[2] = -a[1];
   }
   else if (abs(a[0]) < 0.001) {
      b[0] = 0;
      b[1] = a[2];
      b[2] = -a[1];
   }
   else if (abs(a[1]) < 0.001) {
      b[0] = -a[2];
      b[1] = 0;
      b[2] = a[0];
   }
   else {
      b[0] = a[1];
      b[1] = -a[0]; 
      b[2] = 0;
   }
   normalize(b);

   crossprod(a, b, w);
   normalize(w);

   for (i = 0; i < pn; i++) {
      alpha = 2*3.1415926*i/pn;
      pts->topx[i] = sin(alpha)*w[0]*rd + cos(alpha)*b[0]*rd + cpt[0];
      pts->topy[i] = sin(alpha)*w[1]*rd + cos(alpha)*b[1]*rd + cpt[1];
      pts->topz[i] = sin(alpha)*w[2]*rd + cos(alpha)*b[2]*rd + cpt[2];
      pts->downx[i] = pts->topx[i] + a[0];
      pts->downy[i] = pts->topy[i] + a[1];
      pts->downz[i] = pts->topz[i] + a[2];
   }
   pts->topx[pn] = pts->topx[0];
   pts->topy[pn] = pts->topy[0];
   pts->topz[pn] = pts->topz[0];

   pts->downx[pn] = pts->downx[0];
   pts->downy[pn] = pts->downy[0];
   pts->downz[pn] = pts->downz[0];

}

void drawDodecahedron(int length, float rd, FILE *fp)
{
   int i, j;
   GLdouble center[3];
   GLdouble sc = 1.5*rd;
   static void Dodecahedron(GLdouble ct[3], GLdouble sc, FILE* fp, int);

     fprintf(fp, "  Material {diffuseColor  1.0 0.5 0.0}\n");
     fprintf(fp, "  Coordinate3 {\n");
       fprintf(fp, "\tpoint [\n");
 
         for (i = 0; i <= length; i++) {
               center[0] = x[i];
               center[1] = y[i];
               center[2] = z[i];
	       Dodecahedron(center, sc, fp, 0);
         }
       fprintf(fp, "\t]\n");
     fprintf(fp, "    }\n");

     fprintf(fp, "  Separator {\n");
 
       fprintf(fp, "\tNormal {\n");
       fprintf(fp, "\t   vector [\n");
 
	  for (i = 0; i <= length; i++) {
               center[0] = x[i];
               center[1] = y[i];
               center[2] = z[i];
               Dodecahedron(center, sc, fp, 1);
	  }
       fprintf(fp, "\t   ]\n");
       fprintf(fp, "\t}\n");
 
       fprintf(fp, "\tIndexedFaceSet {\n");
         fprintf(fp, "\t  coordIndex [\n");
 
         for (i = 0; i <= length*60; i+=60) 
           for (j = 0; j < 60; j+=5) 
             fprintf(fp, "\t  %d,%d,%d,%d,%d,-1,\n",
			  i+j,i+j+1,i+j+2,i+j+3,i+j+4);
 
         fprintf(fp, "\t  ]\n");
	
	 fprintf(fp, "\t  normalIndex [\n");
 
         for (i = 0; i <= length*60; i+=60)
           for (j = 0; j < 60; j+=5)
             fprintf(fp, "\t  %d,%d,%d,%d,%d,-1,\n",
                          i+j,i+j+1,i+j+2,i+j+3,i+j+4);
 
         fprintf(fp, "\t  ]\n");
       fprintf(fp, "\t}\n");
 
     fprintf(fp, "  }\n");
}

extern void initdodec(GLdouble dodec[20][3]);

/* dodecahedron:
 *
 * Draws an dodecahedron with center at 0.0. The radius
 * is sqrt(3).
 */
static void Dodecahedron(GLdouble ct[3], GLdouble sc, FILE* fp, int type)
{
    GLdouble dodec[20][3];
    static void pentagon(GLdouble [3], GLdouble [3], GLdouble [3], 
			GLdouble [3], GLdouble [3], GLdouble [3], FILE*, int);
    void initdodec(GLdouble dodec[20][3]);
 
    initdodec(dodec);
    pentagon(ct, &dodec[0][0], &dodec[1][0], &dodec[9][0],
                   &dodec[16][0], &dodec[5][0], fp, type);
    pentagon(ct, &dodec[1][0], &dodec[0][0], &dodec[3][0],
                   &dodec[18][0], &dodec[7][0], fp, type);
    pentagon(ct, &dodec[1][0], &dodec[7][0], &dodec[11][0],
                   &dodec[10][0], &dodec[9][0], fp, type);
    pentagon(ct, &dodec[11][0], &dodec[7][0], &dodec[18][0],
                   &dodec[19][0], &dodec[6][0], fp, type);
    pentagon(ct, &dodec[8][0], &dodec[17][0], &dodec[16][0],
                   &dodec[9][0], &dodec[10][0], fp, type);
    pentagon(ct, &dodec[2][0], &dodec[14][0], &dodec[15][0],
                   &dodec[6][0], &dodec[19][0], fp, type);
    pentagon(ct, &dodec[2][0], &dodec[13][0], &dodec[12][0],
                   &dodec[4][0], &dodec[14][0], fp, type);
    pentagon(ct, &dodec[2][0], &dodec[19][0], &dodec[18][0],
                   &dodec[3][0], &dodec[13][0], fp, type);
    pentagon(ct, &dodec[3][0], &dodec[0][0], &dodec[5][0],
                   &dodec[12][0], &dodec[13][0], fp, type);
    pentagon(ct, &dodec[6][0], &dodec[15][0], &dodec[8][0],
                   &dodec[10][0], &dodec[11][0], fp, type);
    pentagon(ct, &dodec[4][0], &dodec[17][0], &dodec[8][0],
                   &dodec[15][0], &dodec[14][0], fp, type);
    pentagon(ct, &dodec[4][0], &dodec[12][0], &dodec[5][0],
                   &dodec[16][0], &dodec[17][0], fp, type);
}
 
static void pentagon(GLdouble ct[3], GLdouble v1[3], GLdouble v2[3],
        GLdouble v3[3], GLdouble v4[3], GLdouble v5[3], FILE* fp, int type)
{
    GLdouble d1[3], d2[3], d3[3], d4[3], d5[3];
 
    scalarmult(0.15, v1, d1);
    scalarmult(0.15, v2, d2);
    scalarmult(0.15, v3, d3);
    scalarmult(0.15, v4, d4);
    scalarmult(0.15, v5, d5);
 
    if (type == NORMAL) {
       normalize(d1); 
       normalize(d2); 
       normalize(d3); 
       normalize(d4); 
       normalize(d5); 

       fprintf(fp, "\t\t %f %f %f,\n", d1[0], d1[1], d1[2]);
       fprintf(fp, "\t\t %f %f %f,\n", d2[0], d2[1], d2[2]);
       fprintf(fp, "\t\t %f %f %f,\n", d3[0], d3[1], d3[2]);
       fprintf(fp, "\t\t %f %f %f,\n", d4[0], d4[1], d4[2]);
       fprintf(fp, "\t\t %f %f %f,\n", d5[0], d5[1], d5[2]);
    }
    else {
       add3 (d1, ct, d1);
       add3 (d2, ct, d2);
       add3 (d3, ct, d3);
       add3 (d4, ct, d4);
       add3 (d5, ct, d5);

       fprintf(fp, "\t\t %f %f %f,\n", d1[0], d1[1], d1[2]);
       fprintf(fp, "\t\t %f %f %f,\n", d2[0], d2[1], d2[2]);
       fprintf(fp, "\t\t %f %f %f,\n", d3[0], d3[1], d3[2]);
       fprintf(fp, "\t\t %f %f %f,\n", d4[0], d4[1], d4[2]);
       fprintf(fp, "\t\t %f %f %f,\n", d5[0], d5[1], d5[2]);
    }
}

/********************************************/
/*WriteWavefrontFile:                       */
/********************************************/
void
WriteWavefrontFile (int in, int side, int length, FILE *fp)
{
   int i;
   float x0, y0, z0;
   static int pos;
 
   float NM = arg.M;
   float NY = arg.Y;
   float NZ = arg.Z;

   if (in == 0) {
      if (arg.lattice) {
         NM = NM*sqrt(2.0);
         NZ = NZ*sqrt(2.0);
      }
 
      x0 = 0.0; y0 = -1.0*NY; z0 = -1.0*NZ;
      fprintf(fp, "v  %f %f %f,\n", x0, y0, z0);
      y0 = 1.0*NY;
      fprintf(fp, "v  %f %f %f,\n", x0, y0, z0);
      z0 = NZ;
      fprintf(fp, "v  %f %f %f,\n", x0, y0, z0);
      y0 = -1.0*NY;
      fprintf(fp, "v  %f %f %f,\n", x0, y0, z0);

      fprintf(fp, "f 1 2 3 4 \n");

      x0 = NM; y0 = -NY; z0 = -NZ;
      fprintf(fp, "v  %f %f %f,\n", x0, y0, z0);
      y0 = NY;
      fprintf(fp, "v  %f %f %f,\n", x0, y0, z0);
      z0 = NZ;
      fprintf(fp, "v  %f %f %f,\n", x0, y0, z0);
      y0 = -NY;
      fprintf(fp, "v  %f %f %f,\n", x0, y0, z0);
 
      fprintf(fp, "f 5 6 7 8 \n");
      pos = 9;
   }
   else if (in == -1)
      pos = 1; 

   for (i = 0; i <= length; i++)
       fprintf(fp, "v  %f %f %f \n", x[i], y[i], z[i]);
   fprintf(fp, "f ");
   for (i = 0; i <= length; i++)
       fprintf(fp, "%d ", i+pos);
   for (i = length - 1; i >= 1; i--)
       fprintf(fp, "%d ", i+pos);
   fprintf(fp, "\n");

   pos += length+1;
}

