static char SccsId[] = "@(#)teaching_aid.c	1.1 06/24/97 polymer";

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <tcl.h>
#include <tk.h>
#include <togl.h>
#include "polymerl.h"

extern struct PLargs arg;
extern float *x, *y, *z;
extern int Color_Revert;
static GLfloat green_color[4] = { 0.0, 1.0, 0.0 };
static GLfloat blue_color[4] = { 0.0, 1.0, 1.0 };
static GLfloat red_color[4] = { 1.0, 0.0, 0.0 };
static GLfloat black_color[4] = { 0.0, 0.0, 0.0 };
static GLfloat white_color[4] = { 1.0, 1.0, 1.0 };
static GLfloat silver_color[4] = { 0.9, 0.9, 0.8 };

/********************************************/
/*drawcubic_lattice:
  draw cubic lattice
  using OpenGL                              */
/********************************************/
void
drawcubic_lattice ()
{
   int x, y, z;

   if ( Color_Revert )
	glColor3fv (black_color);
   else
        glColor3fv (white_color);

   glDisable (GL_LIGHTING);

   z = 12;
   for (x = 0; x <= z; x+=3) {
      for (y = 0; y <= z; y+=3) {
        glBegin (GL_LINES);
           glVertex3f (0, x, y);
           glVertex3f (z, x, y);
        glEnd ();
        glBegin (GL_LINES);
           glVertex3f (x, 0, y);
           glVertex3f (x, z, y);
        glEnd ();
        glBegin (GL_LINES);
           glVertex3f (x, y, 0);
           glVertex3f (x, y, z);
        glEnd ();
      }
   }
  glEnable (GL_LIGHTING);
}
/********************************************/
/*drawdiamond_lattice:
  draw diamond lattice
  using OpenGL*/
/********************************************/
void
drawdiamond_lattice ()
{
   int i;
   int x0, y0, z0;
   int x, y, z;
   int x_new, y_new, z_new;

   float scy = 1.5;
   float sc = 1.5*1.414213562;
 
   if ( Color_Revert )
	glColor3fv (black_color);
   else
        glColor3fv (white_color);
   
   glDisable (GL_LIGHTING);
 
   for (y0 = 0; y0 <= 8; y0+=4) {
      x0 = 0;
      for (z0 = 0; z0 < 7; z0++) {
         glBegin (GL_LINES);
         x = x0;  
         y = y0 + z0%2;
         for (i= 0; i < 6; i++) {
           glVertex3f (x*sc, y*scy, z0*sc);
           x_new = x+1; 
           y_new = y - (2*(i%2)-1)*(2*(z0%2)-1); 
           glVertex3f (x_new*sc, y_new*scy, z0*sc);
           x = x_new;  
           y = y_new;  
         }
         glEnd ();
      }
      z0 = 0;
      for (x0 = 0; x0 < 7; x0++) {
         glBegin (GL_LINES);
         y = y0 - x0%2; 
         z = z0;
         for (i= 0; i < 6; i++) {
           glVertex3f (x0*sc, y*scy, z*sc);
           y_new = y + (2*(x0%2)-1)*(2*(i%2)-1); 
           z_new = z+1; 
           glVertex3f (x0*sc, y_new*scy, z_new*sc);
           y = y_new;  
           z = z_new;
         }
         glEnd ();
      }
   }
   glEnable (GL_LIGHTING);
}
/********************************************/
/*drawstates:
  draw trans, gauche+ and gauche- states
  using OpenGL*/
/********************************************/
void
drawstates (int states)
{
   GLfloat x[4], y[4], z[4];
   GLfloat x1[4], y1[4], z1[4];
   int i, j;
   GLfloat carbon = 6.0, hydrogen = 3.0, sc = 6;
   float sq2 = 1.414213562;

   x[0] = y[0] = z[0] = 0;
   x[1] = sq2; y[1] = 1; z[1] = 0;
   x[2] = 2*sq2; y[2] = z[2] = 0;

   if (states == 0) {
      x[3] = 3*sq2; y[3] = 1; z[3] = 0;
   } 
   else if (states == 1) {
      x[3] = x[2]; y[3] = y[2] - 1; z[3] = z[2] + sq2;
   } 
   else {
      x[3] = x[2]; y[3] = y[2] - 1; z[3] = z[2] - sq2;
   }
   x1[0] = x[1]; y1[0] = y[1]+0.5; z1[0] = z[1]+sq2/2;
   x1[1] = x[1]; y1[1] = y[1]+0.5; z1[1] = z[1]-sq2/2;

   if (states == 0) {
      x1[2] = x[2]; y1[2] = y[2]-0.5; z1[2] = z[2]+sq2/2;
      x1[3] = x[2]; y1[3] = y[2]-0.5; z1[3] = z[2]-sq2/2;
   }
   else if (states == 1) {
      x1[2] = 2.5*sq2; y1[2] = 0.5; z1[2] = 0;
      x1[3] = x[2]; y1[3] = y[2]-0.5; z1[3] = z[2]-sq2/2;
   }
   else {
      x1[2] = x[2]; y1[2] = y[2]-0.5; z1[2] = z[2]+sq2/2;
      x1[3] = 2.5*sq2; y1[3] = 0.5; z1[3] = 0;
   }
   
   glDisable (GL_LIGHTING);

   /* points for C atoms */
   glColor3fv (green_color);
   glPointSize(carbon);
   glBegin (GL_POINTS);
      for (i = 0; i < 4; i++)   
         glVertex3f (x[i]*sc, y[i]*sc, z[i]*sc);
   glEnd ();
   /* points for H atoms */
   glColor3fv (red_color);
   glPointSize(hydrogen);
   glBegin (GL_POINTS);
      for (i = 0; i < 4; i++)   
         glVertex3f (x1[i]*sc, y1[i]*sc, z1[i]*sc);
   glEnd ();

   if ( Color_Revert )
	glColor3fv (black_color);
   else
        glColor3fv (white_color);
   
   for (i = 0; i < 3; i++) {   
      glBegin (GL_LINES);
         glVertex3f (x[i]*sc, y[i]*sc, z[i]*sc);
         glVertex3f (x[i+1]*sc, y[i+1]*sc, z[i+1]*sc);
      glEnd ();
   }
   for (i = 1; i < 3; i++) 
   for (j = 0; j < 2; j++) {
      glBegin (GL_LINES); 
         glVertex3f (x[i]*sc, y[i]*sc, z[i]*sc);
         glVertex3f (x1[j+(i-1)*2]*sc, y1[j+(i-1)*2]*sc, z1[j+(i-1)*2]*sc);
      glEnd ();
   }
   glEnable (GL_LIGHTING);  
}

