find_path(CULA_INCLUDE_DIR
  cula.h
  PATHS ${CULA_DIR}
  PATH_SUFFIXES include
)
IF(CULA_INCLUDE_DIR STREQUAL "CULA_INCLUDE_DIR-NOTFOUND")
  MESSAGE(FATAL_ERROR "Could not locate header cula.h for CULA library.")
ELSE()
  MESSAGE(STATUS      "Found CULA headers: ${CULA_INCLUDE_DIR}")
ENDIF()

find_library(libcula_core
  NAMES cula_core 
  PATHS ENV CULA_DIR
  HINTS ${CULA_INCLUDE_DIR}/..
  PATH_SUFFIXES lib
)
IF(libcula_core STREQUAL "libcula_core-NOTFOUND")
  MESSAGE(FATAL_ERROR "Could not locate cula_core")
ELSE()
  MESSAGE(STATUS      "Found cula_core: ${libcula_core}")
ENDIF()

find_library(libcula_cudart
  NAMES cudart
  PATHS ENV CULA_DIR
  HINTS ${CULA_INCLUDE_DIR}/..
  PATH_SUFFIXES lib
)
IF(libcula_cudart STREQUAL "libcula_cudart-NOTFOUND")
  MESSAGE(FATAL_ERROR "Could not locate cudart")
ELSE()
  MESSAGE(STATUS      "Found cudart: ${libcula_cudart}")
ENDIF()

find_library(libcula_cublas
  NAMES cublas
  PATHS ENV CULA_DIR
  HINTS ${CULA_INCLUDE_DIR}/..
  PATH_SUFFIXES lib
)
IF(libcula_cublas STREQUAL "libcula_cublas-NOTFOUND")
  MESSAGE(FATAL_ERROR "Could not locate cula_blas")
ELSE()
  MESSAGE(STATUS      "Found cula_blas: ${libcula_cublas}")
ENDIF()

find_library(libcula_lapack
  NAMES cula_lapack
  PATHS ENV CULA_DIR
  HINTS ${CULA_INCLUDE_DIR}/..
  PATH_SUFFIXES lib
)
IF(libcula_lapack STREQUAL "libcula_lapack-NOTFOUND")
  MESSAGE(FATAL_ERROR "Could not locate cula_lapack")
ELSE()
  MESSAGE(STATUS      "Found cula_lapack: ${libcula_lapack}")
ENDIF()
