#ifndef GINCSVD_KERNELS_DECL_HPP_
#define GINCSVD_KERNELS_DECL_HPP_

namespace GINCSVD {

  namespace details {

    template <class T>
    void leftScale(int N, T *A, int LDA, const T* diag);

    template <class T>
    void rightScale(int N, T *A, int LDA, const T* diag);

    template <class T>
    void copyUpperTri(int N, const T *A, int LDA, T *B, int LDB, cudaStream_t stream = 0);

    template <class T>
    void copyToDiag(int M, int N, T *A, int LDA, const T *D, cudaStream_t stream = 0);
  }

}

#endif // GINCSVD_KERNELS_DECL_HPP_
