#include "gincsvd_kernels_def.cuh"
#include "gincsvd_config.h"

#define INSTANT(T) \
  template void GINCSVD::details::leftScale<T>(int, T *, int, const T*); \
  template void GINCSVD::details::rightScale<T>(int, T *, int, const T*); \
  template void GINCSVD::details::copyUpperTri<T>(int, const T *, int, T*, int, cudaStream_t); \
  template void GINCSVD::details::copyToDiag(int, int, T *, int, const T *, cudaStream_t);

#ifdef GINCSVD_FLOAT
  INSTANT(float)
#endif
#ifdef GINCSVD_DOUBLE
  INSTANT(double)
#endif
