function y = applyAtA(x,A);
% Applies A'*A, given some rectangular matrix A.
%
% Calling
% y = applyAtA(A,x)
% applies the operator A'*A to x without 
% requiring the explicit formation of A'*A
% This is useful for converting SVD problems into 
% an eigenvalue problem suitable for an iterative 
% eigensolver.
y = A'*(A*x);
