function t = precDLP(D,L,P,Bx,s)
%  Function wrapper for applying DLP preconditioners.
%
% t = precDLP(D,L,P,Bx,s)
% solves the equation
%   P_{Bx,Bx} A P_{Bx,Bx} t = s
% with solution
%   t = P_{inv(A)Bx,Bx} inv(A) s
% using an approximate inverse of A,
%   P A P^T ~= L D L^T
% It is assumed that P_{Bx,Bx} s = s, i.e.
% s is perpendicular to Bx
    p = size(s,2);

    % solve A t = s
    % then  A u = B x
    if isempty(D),
        t(P,:) = L' \ ( L \  s(P,:) );
        u(P,:) = L' \ ( L \ Bx(P,:) );
    elseif isempty(L),
        t(P,:) = D \  s(P,:);
        u(P,:) = D \ Bx(P,:);
    else
        t(P,:) = L' \ ( D \ ( L \  s(P,:) ));
        u(P,:) = L' \ ( D \ ( L \ Bx(P,:) ));
    end
    % apply P_{u,Bx} to t
    t = t - u * ( (Bx'*u) \ (Bx'*t) );
    return;
