#define sqr(x) ( (x)*(x) )
#define max(x,y) ( (x) < (y) ? (y) : (x) )
#define min(x,y) ( (x) < (y) ? (x) : (y) )
#define eval_max(x,y) x = max(x,y)
#define eval_min(x,y) x = min(x,y)
#define abs_max(x,y) max( fabs(x),fabs(y) )
#define abs_min(x,y) min( fabs(x),fabs(y) )
#define sign(x) ( ( (x) <= 0.0 ) ? -1.0 : 1.0 )
#define minmod(x,y) ( sign(x) != sign(y) ? 0.0 : sign(x)*abs_min(x,y) )

#define TRUE 1
#define FALSE 0

#define INTERIOR 0
#define EXTERIOR 1
#define DISREGARD 2

#define PERIODIC 1
#define CPT_SUPPORT 0
#define FREE_BDRY 2
#define SYMMETRIC 3
#define REFLECT_BDRY 4
#define AXISYMMETRIC 5
#define INFLOW 6

#define D1_DUMP 0
#define D2_DUMP 1
#define D3_DUMP 2
#define U_DUMP 3
#define V_DUMP 4
#define S_DUMP 5
#define W_DUMP 6
#define M_DUMP 7
#define P_DUMP 8

#define is_distance(d_code) ((d_code==D1_DUMP)||(d_code==D2_DUMP)||  \
                             (d_code==D3_DUMP))

#define imax_1d 1000

#define imax 200
#define jmax 200
#define tolerance_matrix 1.0e-8

typedef int logical;

#define clr(xx) xx[ix][iy]=0.0

#define for_all_x for (ix=0;ix<=mx+1;ix++)
#define for_all_y for (iy=0;iy<=my+1;iy++)
#define for_all_y_back for (iy=my+1;iy>=0;iy--)
#define for_all_points for_all_y for_all_x

#define for_xdomain for (ix=1;ix<=mx;ix++)
#define for_ydomain for (iy=1;iy<=my;iy++)
#define for_y_back_domain for (iy=my;iy>=1;iy--)
#define for_domain for_ydomain for_xdomain

#define for_all_x_int for (ix=ixmin;ix<=ixmax;ix++)
#define for_all_y_int for (iy=iymin;iy<=iymax;iy++)
#define for_all_points_int for_all_y_int for_all_x_int

#define pointx_ok ((ix>0)&&(ix<mx+1))
#define pointy_ok ((iy>0)&&(iy<my+1))
#define point_ok  ((pointx_ok)&&(pointy_ok))

#define point1_x(x1) (( (x1)>ixmin-1 ) && ( (x1)<ixmax+1 ))
#define point1_y(y1) (( (y1)>iymin-1 ) && ( (y1)<iymax+1 ))
#define point1_xy(x1,y1) ((point1_x(x1)) && (point1_y(y1)))

#define point1x_ok (point1_x(ix))
#define point1y_ok (point1_y(iy))
#define point1_ok  (point1_xy(ix,iy))

#define point2_x(x1) (( (x1)>-1 ) && ( (x1)<mx+2 ))
#define point2_y(y1) (( (y1)>-1 ) && ( (y1)<my+2 ))
#define point2_xy(x1,y1) ((point2_x(x1)) && (point2_y(y1)))

#define point2x_ok (point2_x(ix))
#define point2y_ok (point2_y(iy))
#define point2_ok  (point2_xy(ix,iy))

#define gd1(ix,iy) gd(1,(ix),(iy))
#define gd11(ix,iy) gd(11,(ix),(iy))
#define gd2(ix,iy) gd(2,(ix),(iy))
#define gd3(ix,iy) gd(3,(ix),(iy))

