#include <stdio.h>
#include <math.h>
#include <string.h>
#include "eno.h"

#include "eno.xtn"
#include "fluids.xtn"

#define dprintf(xx) if (use_debug == TRUE) printf(xx)
#define dprintf2(xx,yy) if (use_debug == TRUE) printf(xx,yy)

FILE *init_parameter_stream,*log_file;
int fscan_status;


logical read_logical()
{
logical in_logical;
char in_string[20];

  fscan_status = fscanf(init_parameter_stream,"%s%d\n",&in_string,&in_logical);
  if (in_logical == TRUE)
    {
     dprintf( "TRUE\n" );
    }
  else 
    {
     dprintf( "FALSE\n" );
    }

  return in_logical;
}

int read_int()
{
int in_int;

  fscan_status = fscanf(init_parameter_stream,"%*s%d\n",&in_int);
  dprintf2("%5d\n",in_int);

  return in_int;
}

double read_double()
{
double in_double;

  fscan_status = fscanf(init_parameter_stream,"%*s%lf\n",&in_double);
  dprintf2("%10.4f\n",in_double);

  return in_double;
}

logical find_token(key)
char *key;
{
int i,j,key_len,f_len;
logical found,test;

  key_len=strlen(key);
  f_len=strlen(file_name);
  i=1;
  found=FALSE;
  while ((! found)&&(i+key_len-1<=f_len))
   {
    test=TRUE;
    for (j=1;j<=key_len;j++)
     if (file_name[i+j-2] != key[j-1])
      test=FALSE;
    if (test)
     found=TRUE;
    i++;
   }

  printf("token is %5d, %s\n",found,key);
  return found;
}   /* find_token */
  
/* read data from eno.dat for initializing the simulation */
void init_parameters()
{
char log_file_name[14],s1[25],s2[25];
logical do_contour,use_compression,always_use_LLF,
  never_use_LLF,front_detect,use_speed,always_use_inversion,
  primitive_mass,primitive_velocity,use_color,use_isothermal,
  use_distance,no_mix,exact_riemann_solver,stokes_flow,
  bias_velocity,bias_density,gravity_fix,ab_flag,area_fix,
  use_curvature;
double ac_constant,alpha_water,ac_detect,
  density_spread_prj,ac_difference_constant,acm_detect;
int r_time,r_space,ac_type,projection_type,convection_type,
    low_space,i_max,j_max;

  printf("initializing parameters.  Opening eno.dat ... \n");
  init_parameter_stream = fopen("eno.dat","r");
  if (init_parameter_stream == NULL)
    printf("Error opening file.\n");

  use_debug = FALSE;
  dprintf("use_debug : ");
  use_debug = read_logical();
  dprintf("do_contour : ");
  do_contour = read_logical();
  dprintf("use compression : ");
  use_compression = read_logical();  
  dprintf("always_use_LLF : ");
  always_use_LLF = read_logical();
  dprintf("never_use_LLF : ");
  never_use_LLF = read_logical();
  dprintf("dump_stepsize : ");
  dump_stepsize = read_double();
  dprintf("CFL number (lambda_zero) : ");
  lambda_zero = read_double();
  dprintf("fluid_select : ");
  fluid_select = read_int();
  dprintf("grid points (x) (mx-1): ");
  mx = read_int()+1;
  dprintf("grid points (y) (my-1): ");
  my = read_int()+1;
  dprintf("time order of accuracy : ");
  r_time = read_int();
  dprintf("spatial order MINUS one : ");
  r_space = read_int();
  dprintf("time cut off : ");
  t_stop = read_double();
  dprintf("ac_constant : ");
  ac_constant = read_double();
  dprintf("ac_difference_constant : ");
  ac_difference_constant = read_double();
  dprintf("alpha_water : ");
  alpha_water = read_double();
  dprintf("density_water : ");
  density_water = read_double();
  dprintf("front detect : ");
  front_detect = read_double();
  dprintf("artifical compression type : ");
  ac_type = read_int();
  dprintf("use_speed : ");
  use_speed = read_logical();
  dprintf("low spatial order MINUS one : ");
  low_space = read_int();
  dprintf("acm_detect : ");
  acm_detect = read_double();
  dprintf("always_use_inversion : ");
  always_use_inversion = read_logical();
  dprintf("primitive_mass : ");
  primitive_mass = read_logical();
  dprintf("primitive_velocity : ");
  primitive_velocity = read_logical();
  dprintf("i_max : ");
  i_max = read_int();
  dprintf("j_max : ");
  j_max = read_int();
  dprintf("use_axisymmetric : ");
  use_axisymmetric = read_logical();

  dprintf("use_color : ");
  use_color = read_logical();
  dprintf("use_isothermal : ");
  use_isothermal = read_logical();
  dprintf("use_distance : ");
  use_distance = read_logical();

  dprintf("no_mix : ");
  no_mix = read_logical();

  dprintf("exact_riemann_solver : ");
  exact_riemann_solver = read_logical();

  dprintf("laplace_coeff : ");
  laplace_coeff = read_double();

  dprintf("boussinesq_coeff : ");
  boussinesq_coeff = read_double();

  dprintf("laplace1_coeff : ");
  laplace1_coeff = read_double();

  dprintf("stokes_flow : ");
  stokes_flow = read_logical();

  dprintf("gravity : ");
  gravity = read_double();

  dprintf("projection_type : ");
  projection_type = read_int();

  dprintf("delta_t_override : ");
  delta_t_override = read_double();

  dprintf("density_spread : ");
  density_spread = read_double();

  dprintf("viscosity_water : ");
  viscosity_water = read_double();

  dprintf("surface_tension_level : ");
  surface_tension_level = read_double();

  dprintf("density_air : ");
  density_air = read_double();

  dprintf("viscosity_air : ");
  viscosity_air = read_double();

  dprintf("viscosity_spread : ");
  viscosity_spread = read_double();

  dprintf("density_spread_prj : ");
  density_spread_prj = read_double();
  if ((density_spread_prj < 0.0) || (density_spread_prj > 5.0))
    printf("error density_spread_prj\n");

  dprintf("convection_type : ");
  convection_type = read_int();

  dprintf("bias_velocity : ");
  bias_velocity = read_logical();

  dprintf("bias_density : ");
  bias_density = read_logical();

  dprintf("gravity_fix : ");
  gravity_fix = read_logical();

  dprintf("ab_flag : ");
  ab_flag = read_logical();

  dprintf("area_fix : ");
  area_fix = read_logical();

  dprintf("use_curvature : ");
  use_curvature = read_logical();

  dprintf("file_name : ");
  fscan_status = fscanf(init_parameter_stream,"%*s%s\n",file_name);
  dprintf2("%s\n",file_name);

  reposition=find_token("axi");
  colortest=find_token("colortest");
  gas_burst_under=find_token("gas_sub");
  reinit_test=find_token("reinit_test");
  axipinch=find_token("axipinch"); 
  use_bmo=find_token("bmo");
  free_boundary_flag=find_token("free");
  if (fluid_select==80)     /* zalesaks problem */
   free_boundary_flag=TRUE;

  brute_force_flag=find_token("brute");
  emad_flag=find_token("emad");
  puckett_flag=find_token("puckett");
  marcus_flag=find_token("marcus");
  stokes_flag=find_token("stokes");
  stokes_linear_flag=find_token("stokesl");
  standing_wave_flag=find_token("standing");
  stokes_breaking_flag=find_token("stokes_break");
  stokes_wind_flag=((stokes_flag)&&(find_token("wind")));
  stokes_random=((stokes_flag)&&(find_token("random")));
  terminal_flag=find_token("terminal");
  pressure_test=find_token("pressure_test");
  freetest_flag=find_token("freeaxitest");

  zalesakcmp=find_token("zalesakcmp");
  reinit_level=(! find_token("noreinit"));
/*
  if (find_token("dcenter"))
   diff_type=0;
  else if (find_token("dnoncons"))
   diff_type=1;
  else
   diff_type=2;
 
  printf("diff_type is : %5d\n",diff_type);
*/

  order_space=2;   /* order used during reinitialization */
  if (find_token("reinit_test_1"))
   order_space=1;
  if (find_token("reinit_test_2"))
   order_space=2;
  if (find_token("reinit_test_3"))
   order_space=3;
 
  exact_flag=FALSE;
  if ((solid_body())&&(find_token("exact")))
   exact_flag=TRUE;
 
  dprintf("use_archive : ");
  use_archive = read_int();

  dprintf("archive_stepsize : ");
  archive_stepsize = read_double();

  dprintf("density_oil : ");
  density_oil = read_double();

  dprintf("viscosity_oil : ");
  viscosity_oil = read_double();

  dprintf("tension_oil_air : ");
  tension_oil_air = read_double();

  dprintf("tension_oil_water : ");
  tension_oil_water = read_double();

  dprintf("feed_back_dnum : ");
  feed_back_dnum = read_int();

  dprintf("wind_speed : ");
  wind_speed = read_double();

  dprintf("wind_parameter : ");
  wind_parameter = read_double();

  fscan_status = fclose(init_parameter_stream);

  init_parameter_stream = fopen("eno.dat","r");
  sprintf(log_file_name,"%s.log",file_name);
  log_file = fopen(log_file_name,"w");

  while (feof(init_parameter_stream) == 0)
    {
     fscan_status = fscanf(init_parameter_stream,"%s%s",&s1,&s2);
     fscan_status = fprintf(log_file,"%s %s\n",&s1,&s2);
    }
  fscan_status = fclose(log_file);
  fscan_status = fclose(init_parameter_stream);
}  
