/* units :  Wieght M = (g/mol) (atomic mass) 
            helium = He 4.0026
            air = NO 14.0067+15.9994
            water = H2O 2*1.0080+15.9994

            Universal gas constant Ru = 8.314 (J/(mol x K))
            Cp,Cv  - in physics tables J/(mol x K)   (28.97,20.8)
                     in paper Cp - Cv = Ru/M = (J/(g x K))

   helium is a monatomic gas.
   air is a diatomic gas.

   NOTE : OK TO USE (g) instead of (kg) for Cp,Cv  since the only
          constant I use is gamma which is Cp/Cv.  gamma is a
          non-dimensionalized constant.
    EXCEPT WHEN I USE Cp-Cv.  As in P = (Cp-Cv)density x temp

    AS OF 8/2/92 I will be using kg for Cp,Cv by making the weights
    be (kg/mol).
*/

#define pi 3.14159265358
#define root_two 1.414213562

#define Ru 8.314

#define alpha_monatomic 3.0
#define alpha_diatomic 5.0
#define alpha_test 10.0

/* density = kg/(meter cubed) */

/* see eno_conf #define density_air 1.293  */
#define weight_air (28.97/1000) 
#define constant_volume_air (0.5*alpha_diatomic*Ru/weight_air)
#define constant_pressure_air (constant_volume_air+Ru/weight_air)  
#define specific_heat_air (1.0+2.0/alpha_diatomic)

#define density_test 1.293
#define weight_test (28.97/1000) 
#define constant_volume_test (0.5*alpha_test*Ru/weight_test)
#define constant_pressure_test (constant_volume_test+Ru/weight_test)  
#define specific_heat_test (1.0+2.0/alpha_test)

#define weight_helium (4.0/1000)
#define constant_volume_helium (0.5*alpha_monatomic*Ru/weight_helium)
#define constant_pressure_helium (constant_volume_helium+Ru/weight_helium)
#define specific_heat_helium (1.0+2.0/alpha_monatomic)

/* relate atm to N/(mXm) */

#define atmosphere 1.013e5
#define B_tait (3268.0*atmosphere)
#define N_water 7.0
/* see eno_conf #define density_water 1.007e3   */
#define weight_water (18.0/1000)
#define constant_volume_water (0.5*alpha_water*Ru/weight_water)
#define constant_pressure_water (constant_volume_water+Ru/weight_water)
#define specific_heat_water (1.0+2.0/alpha_water)

#define almost_same 1.0e-9

#define weight_avg(ul,ur) (weight*(ul) + (1-weight)*(ur))
#define velocity_sqr(velocity_x,velocity_y) ((velocity_x)*(velocity_x) + \
                                             (velocity_y)*(velocity_y))

#define calc_over_density(density) \
         ( ((density) > 0.0) ? (1.0/(density)) : 0.0 )

#define calc_momentum(density,velocity) ((density)*(velocity))

#define calc_front(density,mass_fraction) \
  ( (primitive_mass == TRUE) ? mass_fraction : ((density)*(mass_fraction)) )

#define calc_mass_fraction(front_var,over_density) \
  ( (primitive_mass == TRUE) ? front_var : ((front_var)*(over_density)) )

#define calc_vel(momentum,over_density) ((momentum)*(over_density))

#define calc_enthalpy(energy,pressure,over_density) \
         (((energy)+(pressure))*(over_density))
