% This script runs the numerical experiments of our IARPG and integration 
% algorithm in subsection 5.4.

clear;
clc;

rng('default');
% seed = floor(rand() * 100000);
seed = 20;
rng(seed);

%% Select missing types and rates

% select missing type
MissingType = 'S';  % random small block lambda = 0.001;
% MissingType = 'M';  % random medium blocks
% MissingType = 'L';  % large central blocks

% select missing rate
MissingRate = 0.1:0.1:0.2;

%% test the IARPG algorithm
time_IARPG = zeros(size(MissingRate)); % save the running time at each missing rate
for rate = MissingRate
    sum_time = 0;
    for i=1:112
        if i==14 % the 14th image is not in the database
            continue;
        end
        InputFileName = ['..\..\data\texture_database\D',num2str(i),'.png']; % known image file name
        if strcmp(MissingType,'L')
            MaskFileName = ['..\..\data\mask_',MissingType,'\M',num2str(rate),'.png']; % mask file name
        else
            MaskFileName = ['..\..\data\mask_',MissingType,'\',num2str(rate),'\M',num2str(i),'.png'];
        end
        OutputFileName = ['..\..\experiment5.4\texture_database\result\',MissingType,'\IARPG\',num2str(rate),'\IARPG',num2str(i),'.png']; % output file name

%         % for linux user
%         InputFileName = ['../../data/texture_database/D',num2str(i),'.png']; % known image file name
%         if strcmp(MissingType,'L')
%             MaskFileName = ['../../data/mask_',MissingType,'/M',num2str(rate),'.png']; % mask file name
%         else
%             MaskFileName = ['../../data/mask_',MissingType,'/',num2str(rate),'/M',num2str(i),'.png'];
%         end
%         OutputFileName = ['../../experiment5.4/texture_database/result/',MissingType,'/IARPG/',num2str(rate),'/IARPG',num2str(i),'.png']; % output file name


        A = double(imread(InputFileName));
        E = A;

        normA = norm(A);
        A = A / normA;
        [m, n] = size(A);

        Mask = logical(imread(MaskFileName));

        % determine r
        t1 = 0.2;
        t2 = 0.995;

        A(Mask) = sum(A(:))/sum(sum(~Mask));
        [U, D, V] = svd(A);

        diagD = diag(D);
        normD = sqrt(sum(diagD.^2));
        for r = 1:min(m,n)
            if sqrt(sum(diagD(1:r).^2))/normD >= t2
                break;
            end
        end
        r_max = floor(t1*min(m,n));
        r = min(r,r_max);

        A(Mask)=0;


        U = U(:, 1:r);
        D = D(1:r, 1:r);
        V = V(:, 1:r);

        %     U = orth(randn(m, r));
        %     D = randn(r, r);
        %     V = orth(randn(n, r));
        Xinitial.main = U * D * V';
        Xinitial.U = U;
        Xinitial.D = D;
        Xinitial.V = V;
        type = 2;
        LADMmu = 0.1;
        LADMrho = 1.1;
        LADMeta = 3;


        %method: 1: AManPG, 2: LADM
        method = 1;
        lambda = 0.001; % missing type: S
        % lambda = 0.0015; % missing type: M
        % lambda = 0.002; % missing type: L

        %         method = 2;
        %         lambda = 0.08;


        SolverParams.method = 'IARPG'; % IRPG IARPG
        SolverParams.IsCheckParams = 1;
        %     SolverParams.RPGVariant = 0; %0: RPG without adaptive stepsize, 1: RPG with adaptive stepsize
        SolverParams.LengthW = 1;
        SolverParams.OutputGap = 10;
        SolverParams.Max_Iteration = 500;
        % SolverParams.SMtol = 1e-2;
        SolverParams.Stop_Criterion = 3;
        SolverParams.Tolerance = 1e-3;
        %     SolverParams.Min_Iteration = 10;
        SolverParams.Verbose = 2;


        tic;
        [xopt1] = TestFRankETextureInpainting(sparse(A), lambda, Xinitial, type, method, SolverParams, LADMmu, LADMrho, LADMeta);
        sum_time = sum_time + toc;

        xopt1.main = xopt1.main * normA;
        %     svd(xopt1.main)'
        rA = dct2(xopt1.main);
        E(Mask)=rA(Mask);
        imwrite(uint8(E),OutputFileName);
    end
    time_IARPG(round(rate*10)) = sum_time;
end
time_IARPG


%% Test integration algorithm
time_Integration_2nd = zeros(size(MissingRate));  % save the running time of 2nd stage of integration algorithm at each missing rate
for rate = MissingRate
    sum_time = 0;
    parfor i=1:112
        if i==14 % the 14th image is not in the database
            continue;
        end

        IARPGResultFileName = ['..\..\experiment5.4\texture_database\result\',MissingType,'\IARPG\',num2str(rate),'\IARPG',num2str(i),'.png'];  % the filename of the output results of the IARPG method
        if strcmp(MissingType,'L')
            MaskFileName = ['..\..\data\mask_',MissingType,'\M',num2str(rate),'.png']; % mask file name
        else
            MaskFileName = ['..\..\data\mask_',MissingType,'\',num2str(rate),'\M',num2str(i),'.png'];
        end
        OutputFileName = ['..\..\experiment5.4\texture_database\result\',MissingType,'\Integration\',num2str(rate),'\Integration',num2str(i),'.png']; % output file name

        UseGraphut = 0; % graphcut algorithm is not used for fair comparison
        HalfPatchSize = 4; % i.e. the patch size is 9×9

        tic;
        inpaintedImg = inpaint_2nd_gray(IARPGResultFileName,MaskFileName,HalfPatchSize,UseGraphut);
        sum_time = sum_time + toc;

        imwrite(uint8(inpaintedImg),OutputFileName);
    end
    time_Integration_2nd(round(rate*10)) = sum_time;
end
time_Integration = time_IARPG + time_Integration_2nd
