% This script runs the numerical experiments of our integration algorithm
% in subsection 5.5.

clear;
clc;

rng('default');
% seed = floor(rand() * 100000);
seed = 20;
rng(seed);
disp('method: our integration method')

%%  Select the test image and mask and set parameters

% select the test image number and parameters
TestImageNumber = '1';
lambda = 0.001;
HalfPatchSize = 6;
% 
% TestImageNumber = '2';
% lambda = 0.001;
% HalfPatchSize = 4;
% 
% TestImageNumber = '3';
% lambda = 0.0005;
% HalfPatchSize = 4;
% 
% TestImageNumber = '4';
% lambda = 0.0008;
% HalfPatchSize = 4;
% 
% TestImageNumber = '5';
% lambda = 0.0006;
% HalfPatchSize = 9;
%
% TestImageNumber = '6';
% lambda = 0.0006;
% HalfPatchSize = 3;
% 
% TestImageNumber = '7';
% lambda = 0.0007;
% HalfPatchSize = 3;
% 
% TestImageNumber = '8';
% lambda = 0.0009;
% HalfPatchSize = 9;

UseGraphcut = 1;


InputFileName =  ['..\..\data\natural_images\images\image',TestImageNumber,'.png']; % known image file name
MaskFileName = ['..\..\data\natural_images\masks\mask',TestImageNumber,'.png']; % mask file name
AfterIARPGimgFilename = ['..\..\experiment5.5\natural_images\result\IARPG\IARPGResult',TestImageNumber,'.png']; % the path to the IARPG method (i.e. first stage) results
OutputFileName = ['..\..\experiment5.5\natural_images\result\Integration\Integration',TestImageNumber,'.png']; % the path to the integration method results

% % for linux user
% InputFileName =  ['../../data/natural_images/images/image',TestImageNumber,'.png']; % known image file name
% MaskFileName = ['../../data/natural_images/masks/mask',TestImageNumber,'.png']; % mask file name
% AfterIARPGimgFilename = ['../../experiment5.5/natural_images/result/IARPG/IARPGResult',TestImageNumber,'.png']; % the path to the IARPG method (i.e. first stage) results
% OutputFileName = ['../../experiment5.5/natural_images/result/Integration/Integration',TestImageNumber,'.png']; % the path to the integration method results

%% Stage 1: IARPG 
OriginalImage = double(imread(InputFileName));
Mask = imbinarize(imread(MaskFileName));

E = zeros(size(OriginalImage));
rA = zeros(size(OriginalImage));
normA = zeros(3,1);
Dam = zeros(size(OriginalImage));
r_RGB = zeros(3,1);
for i=1:3 % RGB channel

    A = OriginalImage(:,:,i);
    E(:,:,i) = A;


    normA(i) = norm(A);
    A = A / normA(i);
    [m, n] = size(A);

    % determine r
    t1 = 0.2;
    t2 = 0.995;

    A(Mask) = sum(A(:))/sum(sum(~Mask));
    [U, D, V] = svd(A);

    diagD = diag(D);
    normD = sqrt(sum(diagD.^2));
    for r = 1:min(m,n)
        if sqrt(sum(diagD(1:r).^2))/normD >= t2
            break;
        end
    end
    r_max = floor(t1*min(m,n));
    r = min(r,r_max);

    r_RGB(i)=r;


    A(Mask)=0;
    Dam(:,:,i) = A*normA(i);


    U = U(:, 1:r);
    D = D(1:r, 1:r);
    V = V(:, 1:r);

    %     U = orth(randn(m, r));
    %     D = randn(r, r);
    %     V = orth(randn(n, r));
    Xinitial.main = U * D * V';
    Xinitial.U = U;
    Xinitial.D = D;
    Xinitial.V = V;
    type = 2;
    LADMmu = 0.1;
    LADMrho = 1.1;
    LADMeta = 3;


    %method: 1: AManPG, 2: LADM
    method = 1;

    %     method = 2;
    %     lambda = 0.003;


    SolverParams.method = 'IARPG'; % IRPG IARPG


    SolverParams.IsCheckParams = 1;
    %     SolverParams.RPGVariant = 0; %0: RPG without adaptive stepsize, 1: RPG with adaptive stepsize
    SolverParams.LengthW = 1;
    SolverParams.OutputGap = 10;
    SolverParams.Max_Iteration = 500;
    % SolverParams.SMtol = 1e-2;
    SolverParams.Stop_Criterion = 3;
    SolverParams.Tolerance = 1e-3;
    %     SolverParams.Min_Iteration = 10;
    SolverParams.Verbose = 2;

    [xopt1] = TestFRankETextureInpainting(sparse(A), lambda, Xinitial, type, method, SolverParams, LADMmu, LADMrho, LADMeta);

    xopt1.main = xopt1.main * normA(i);
    %     svd(xopt1.main)'
    rA(:,:,i) = dct2(xopt1.main);
    temp_rA =  rA(:,:,i);
    temp_E = E(:,:,i);
    temp_E(Mask) = temp_rA(Mask);
    E(:,:,i)=temp_E;
end
imwrite(uint8(E),AfterIARPGimgFilename);

%% Stage 2: exemplar-based method

inpaintedImg = inpaint_2nd_rgb(AfterIARPGimgFilename,MaskFileName,HalfPatchSize,UseGraphcut);
imwrite(uint8(inpaintedImg),OutputFileName);


%% Show the results 

figure(1);
subplot(1,4,1);
imshow(uint8(OriginalImage))
title('Original Image')
subplot(1,4,2)
imshow(uint8(Dam));
title('Damged image');
subplot(1,4,3)
imshow(uint8(E));
title('IARPG Result');
subplot(1,4,4)
imshow(uint8(inpaintedImg));
title('Integration Method Result');

%% Some other functions

function M = haarFWT_2d(M)
[n1, n2] = size(M);
tmp = M;
r2 = sqrt(2);
k = 1;
while(2 * k <= n1)
    k = k * 2;
end
while(1 < k)
    k = k / 2;
    for j = 1 : n2
        for i = 1 : k
            tmp(i, j) = (M(2 * i - 1, j) + M(2 * i, j)) / r2;
            tmp(k + i, j) = (M(2 * i - 1, j) - M(2 * i, j)) / r2;
        end
    end
    for j = 1 : n2
        for i = 1 : 2 * k
            M(i, j) = tmp(i, j);
        end
    end
end
k = 1;
while(2 * k <= n2)
    k = k * 2;
end
while(1 < k)
    k = k / 2;
    for j = 1 : k
        for i = 1 : n1
            tmp(i, j) = (M(i, 2 * j - 1) + M(i, 2 * j)) / r2;
            tmp(i, k + j) = (M(i, 2 * j - 1) - M(i, 2 * j)) / r2;
        end
    end
    for j = 1 : 2 * k
        for i = 1 : n1
            M(i, j) = tmp(i, j);
        end
    end
end
end

function M = haarFWT_2d_inverse(M)
[n1, n2] = size(M);
tmp = M;
r2 = sqrt(2);
k = 1;
while(k * 2 <= n2)
    for j = 1 : k
        for i = 1 : n1
            tmp(i, 2 * j - 1) = (M(i, j) + M(i, k + j)) / r2;
            tmp(i, 2 * j) = (M(i, j) - M(i, k + j)) / r2;
        end
    end
    for j = 1 : 2 * k
        for i = 1 : n1
            M(i, j) = tmp(i, j);
        end
    end
    k = k * 2;
end
k = 1;
while(k * 2 <= n1)
    for j = 1 : n2
        for i = 1 : k
            tmp(2 * i - 1, j) = (M(i, j) + M(k + i, j)) / r2;
            tmp(2 * i, j) = (M(i, j) - M(k + i, j)) / r2;
        end
    end
    for j = 1 : n2
        for i = 1 : 2 * k
            M(i, j) = tmp(i, j);
        end
    end
    k = k * 2;
end
end