
seed = floor(rand() * 100000);
seed = 20;
fprintf('TI compare Accuracy in Subproblem seed:%d\n', seed);
rng(seed);


ns = [64, 128, 256, 512];%, 512, 512];
rs = [20, 40, 60, 80]; %, 120];%, 40, 80];
lambdas = [0.00004, 0.00008, 0.00012, 0.00016];

numtest = 10;
testpara = 1; %1 for n, 2 for r, 3 for lambda

load('texture1.mat');
% grayflower = rgb2gray(cdata);
grayflower = double(cdata);

timetab = zeros(3, 4, numtest); % 3 problems, 4 ns/rs/lambdas, numtest
itertab = zeros(3, 4, numtest);
spartab = zeros(3, 4, numtest);

for k = 1 : 4
    if(testpara == 1)
        n1 = ns(k); xvalues = ns; xl = 'n'; % 128 * 8; % 
        n2 = n1;
        r = 40;
        lambda = 0.00012;
    elseif(testpara == 2)
        n1 = 128;
        n2 = 128;
        r = rs(k); xvalues = rs; xl = 'r'; % 4; %  
        lambda = 0.00012;
    elseif(testpara == 3)
        n1 = 128;
        n2 = 128;
        r = 40; %  ps(k); xvalues = ps; xl = 'p'; %
        lambda = lambdas(k); xvalues = lambdas; xl = '\lambda'; %  1; %
    else
        return;
    end
    
    j = 0;
    i = 1;
    while i <= numtest
        [k, i]
        rng((i+j)*777);
        
        startxidx = randi(size(grayflower, 1) - n1 + 1);
        startyidx = randi(size(grayflower, 2) - n2 + 1);
        A = double(grayflower(startxidx : startxidx + n1 - 1, startyidx : startyidx + n2 - 1))/255;
        normA = norm(A);
        A = A / normA;
        Atrue = A;
        [m, n] = size(A);
    
        B = rand(m, n);
        A(B>0.5) = 0;

%         smoothA = reshape(smooth(A(:)), size(A));
%         smoothA = smoothA / max(abs(smoothA(:))) * max(abs(A(:)));
%         [U, D, V] = svd(smoothA);
        [U, D, V] = svd(A);
        U = U(:, 1:r);
        D = (D(1:r, 1:r) + 0.0*eye(r));
        V = V(:, 1:r);
%         svd(D)
% return;
        Xinitial.main = U * D * V';
        Xinitial.U = U;
        Xinitial.D = D;
        Xinitial.V = V;
        type = 1;
        LADMmu = 0.1;
        LADMrho = 1.1;
        LADMeta = 3;

        %method: 1: IRPG, 2: LADM
        method = 1; 
        
        SolverParams.method = 'IRPG'; % IRPG IARPG
        SolverParams.IsCheckParams = 1;
        SolverParams.Variant = 2; %0: RPG without adaptive stepsize, 1: RPG with adaptive stepsize, 2: BB
        SolverParams.LengthW = 1;
        SolverParams.OutputGap = 20;
        SolverParams.Max_Iteration = 5000;
%         SolverParams.SMtol = 1e-2;
        SolverParams.ProxMapType = 0;
        SolverParams.Stop_Criterion = 3;
        SolverParams.Tolerance = 1e-3;
%         SolverParams.Minstepsize = 1e-3;
    %     SolverParams.Min_Iteration = 10;
        SolverParams.Verbose = 2;

        [xopt1, f1, gf, gfgf0, iter1, nf, ng, nR, nV, nVp, nH, ComTime1, funs, grads, times] = ...
            TestFRankETextureInpainting(sparse(A), lambda, Xinitial, type, method, SolverParams, LADMmu, LADMrho, LADMeta);
%         xopt1.main = xopt1.main * normA;
        [funvalue(xopt1, A, type), funerr(xopt1, Atrue, type), sparsity(xopt1, type), sum(svd(xopt1.main) > 1e-6)]

        SolverParams.ProxMapType = 1;
        SolverParams.Stop_Criterion = 0;
        SolverParams.Tolerance = f1;
        [xopt2, f2, gf, gfgf0, iter2, nf, ng, nR, nV, nVp, nH, ComTime2, funs, grads, times] = ...
            TestFRankETextureInpainting(sparse(A), lambda, Xinitial, type, method, SolverParams, LADMmu, LADMrho, LADMeta);
%         xopt1.main = xopt1.main * normA;
        [funvalue(xopt2, A, type), funerr(xopt2, Atrue, type), sparsity(xopt2, type), sum(svd(xopt2.main) > 1e-6)]

        
        SolverParams.ProxMapType = 2;
        SolverParams.Stop_Criterion = 0;
        SolverParams.Tolerance = f1;
        [xopt3, f2, gf, gfgf0, iter3, nf, ng, nR, nV, nVp, nH, ComTime3, funs, grads, times] = ...
            TestFRankETextureInpainting(sparse(A), lambda, Xinitial, type, method, SolverParams, LADMmu, LADMrho, LADMeta);
%         xopt1.main = xopt1.main * normA;
        [funvalue(xopt3, A, type), funerr(xopt3, Atrue, type), sparsity(xopt3, type), sum(svd(xopt3.main) > 1e-6)]

        if(norm(xopt1.main - xopt2.main) < 1e-2 && norm(xopt3.main - xopt2.main) < 1e-2)
            timetab(1, k, i) = ComTime1;
            timetab(2, k, i) = ComTime2;
            timetab(3, k, i) = ComTime3;
            itertab(1, k, i) = iter1;
            itertab(2, k, i) = iter2;
            itertab(3, k, i) = iter3;
            spartab(1, k, i) = sparsity(xopt1, type);
            spartab(2, k, i) = sparsity(xopt2, type);
            spartab(3, k, i) = sparsity(xopt3, type);
            i = i + 1;
        else
            j = j + 1;
        end
    end
    
end

avetime = mean(timetab, 3);
aveiter = mean(itertab, 3);
avespar = mean(spartab, 3);

figure(1);clf;
set(0,'defaultaxesfontsize',15, ...
   'defaultaxeslinewidth',0.7, ...
   'defaultlinelinewidth',.8,'defaultpatchlinewidth',0.8);
set(0,'defaultlinemarkersize',10)
shapes = {'*', 'v', '^', '+', 'o', 'x'};
subplot(1, 3, 1);
for i = [1 : 3]
    plot(xvalues, avetime(i, :), ['-', shapes{i}]); hold on
end
xlabel(xl); ylabel('time');
legend('P-IRPG-G', 'P-IRPG-U', 'P-IRPG-L'); %RPG-Ada

subplot(1, 3, 2);
for i = [1 : 3]
    plot(xvalues, aveiter(i, :), ['-', shapes{i}]); hold on
end
xlabel(xl); ylabel('iter');
legend('P-IRPG-G', 'P-IRPG-U', 'P-IRPG-L');

subplot(1, 3, 3);
for i = [1 : 3]
    plot(xvalues, avespar(i, :), ['-', shapes{i}]); hold on
end
xlabel(xl); ylabel('sparsity');
legend('P-IRPG-G', 'P-IRPG-U', 'P-IRPG-L');


function output = funvalue(x, A, type)
    if(type == 2)
        rA = dct2(x.main);
    else
        rA = haarFWT_2d_inverse(x.main);
    end
    rA(A == 0) = 0;
    
    output = norm(A - rA, 'fro') / norm(A, 'fro');
end

function output = funerr(x, Atrue, type)
    
    if(type == 2)
        rA = dct2(x.main);
    else
        rA = haarFWT_2d_inverse(x.main);
    end
    
    output = norm(Atrue - rA, 'fro') / norm(Atrue, 'fro');
    
end

function output = sparsity(x, type)
    output = sum(sum(abs(x.main) < 1e-4)) / prod(size(x.main));
end

function M = haarFWT_2d(M)
    [n1, n2] = size(M);
    tmp = M;
    r2 = sqrt(2);
    k = 1;
    while(2 * k <= n1)
        k = k * 2;
    end
    while(1 < k)
        k = k / 2;
        for j = 1 : n2
            for i = 1 : k
                tmp(i, j) = (M(2 * i - 1, j) + M(2 * i, j)) / r2;
                tmp(k + i, j) = (M(2 * i - 1, j) - M(2 * i, j)) / r2;
            end
        end
        for j = 1 : n2
            for i = 1 : 2 * k
                M(i, j) = tmp(i, j);
            end
        end
    end
    k = 1;
    while(2 * k <= n2)
         k = k * 2;
    end
    while(1 < k)
        k = k / 2;
        for j = 1 : k
            for i = 1 : n1
                tmp(i, j) = (M(i, 2 * j - 1) + M(i, 2 * j)) / r2;
                tmp(i, k + j) = (M(i, 2 * j - 1) - M(i, 2 * j)) / r2;
            end
        end
        for j = 1 : 2 * k
            for i = 1 : n1
                M(i, j) = tmp(i, j);
            end
        end
    end
end

function M = haarFWT_2d_inverse(M)
    [n1, n2] = size(M);
    tmp = M;
    r2 = sqrt(2);
    k = 1;
    while(k * 2 <= n2)
        for j = 1 : k
            for i = 1 : n1
                tmp(i, 2 * j - 1) = (M(i, j) + M(i, k + j)) / r2;
                tmp(i, 2 * j) = (M(i, j) - M(i, k + j)) / r2;
            end
        end
        for j = 1 : 2 * k
            for i = 1 : n1
                M(i, j) = tmp(i, j);
            end
        end
        k = k * 2;
    end
    k = 1;
    while(k * 2 <= n1)
        for j = 1 : n2
            for i = 1 : k
                tmp(2 * i - 1, j) = (M(i, j) + M(k + i, j)) / r2;
                tmp(2 * i, j) = (M(i, j) - M(k + i, j)) / r2;
            end
        end
        for j = 1 : n2
            for i = 1 : 2 * k
                M(i, j) = tmp(i, j);
            end
        end
        k = k * 2;
    end
end






























% 
% 
% 
% 
% 
% ns = [256, 512, 1024, 2048]; % p = 4, m = 20, lambda = 2
% ps = [1, 2, 4, 8]; % n =1024, m = 20, lambda = 2
% lambdas = [0.25, 0.5, 1, 2]; % n = 1024, p = 4, m = 20
% 
% numtest = 10;
% testpara = 1; %1 for n, 2 for p, 3 for lambda
% 
% timetab = zeros(3, 4, numtest); % 3 problems, 4 ns/ps/bs, numtest
% itertab = zeros(3, 4, numtest);
% spartab = zeros(3, 4, numtest);
% 
% for k = 1 : 4
%     if(testpara == 1)
%         n = ns(k); xvalues = ns; xl = 'n'; % 128 * 8; % 
%         r = 4; %  ps(k); xvalues = ps; xl = 'p'; %
%         lambda = 2; % lambdas(k); xvalues = lambdas; xl = '\lambda'; % 
%     elseif(testpara == 2)
%         n = 1024; % ns(k); xvalues = ns; xl = 'n'; % 
%         r = ps(k); xvalues = ps; xl = 'p'; % 4; %  
%         lambda = 2; % lambdas(k); xvalues = lambdas; xl = '\lambda'; % 
%     elseif(testpara == 3)
%         n = 1024; % ns(k); xvalues = ns; xl = 'n'; % 
%         r = 4; %  ps(k); xvalues = ps; xl = 'p'; %
%         lambda = lambdas(k); xvalues = lambdas; xl = '\lambda'; %  1; %
%     else
%         return;
%     end
%     m = 20;
% %     lambda = b * sqrt(r + log(n));
% %     lambda = 0.5;
%     
%     for i = 1 : numtest
%         [k, i]
%         rng(i);
%         
%         A = randn(m, n);
%         A = A - repmat(mean(A, 1), m, 1);
%         A = A ./ repmat(sqrt(sum(A .* A)), m, 1);
%     
%         [U, S, V] = svd(A, 'econ');
%         PCAV = V(:, 1:r);
%         initx = PCAV;
%         tmp = A * PCAV; maxvar = sum(tmp(:) .* tmp(:));
%         D = diag(S(1:r, 1:r));
%         Dsq = D.^2;
%         Xinitial = PCAV;
% %         Xinitial = orth(randn(n, r));%%---
% 
%         SolverParams.method = 'IRPG';
%         SolverParams.IsCheckParams = 1;
%         SolverParams.Variant = 2; %0: RPG without adaptive stepsize, 1: RPG with adaptive stepsize， 2: BB
%         SolverParams.OutputGap = 50;
%         SolverParams.LengthW = 1;
%         SolverParams.Max_Iteration = 5000;
%         SolverParams.Verbose = 2;
%         SolverParams.ProxMapType = 0;
%         SolverParams.Stop_Criterion = 3;
%         SolverParams.Tolerance = sqrt(1e-8 * n * r); % 1e-3; % 
%         method = 1; %IRPG
%         [xopt1, fIRPG1, gf, gfgf0, iter1, nf, ng, nR, nV, nVp, nH, ComTime1, funs, grads, times] = ...
%             TestStieSPCA(A, lambda, Xinitial, method, 0, SolverParams);
%         sparsity1 = sum(sum(abs(xopt1.main) < 1e-5)) / (n * r);
% % return;
%         SolverParams.ProxMapType = 1;
%         SolverParams.Stop_Criterion = 0;
%         SolverParams.Tolerance = fIRPG1;
%         [xopt2, fIRPG2, gf, gfgf0, iter2, nf, ng, nR, nV, nVp, nH, ComTime2, funs, grads, times] = ...
%             TestStieSPCA(A, lambda, Xinitial, method, 0, SolverParams);
%         sparsity2 = sum(sum(abs(xopt2.main) < 1e-5)) / (n * r);
% 
%         SolverParams.ProxMapType = 2;
%         SolverParams.Stop_Criterion = 0;
%         SolverParams.Tolerance = fIRPG1;
%         [xopt3, fIRPG3, gf, gfgf0, iter3, nf, ng, nR, nV, nVp, nH, ComTime3, funs, grads, times] = ...
%             TestStieSPCA(A, lambda, Xinitial, method, 0, SolverParams);
%         sparsity3 = sum(sum(abs(xopt3.main) < 1e-5)) / (n * r);
%         
%         timetab(1, k, i) = ComTime1;
%         timetab(2, k, i) = ComTime2;
%         timetab(3, k, i) = ComTime3;
%         itertab(1, k, i) = iter1;
%         itertab(2, k, i) = iter2;
%         itertab(3, k, i) = iter3;
%         spartab(1, k, i) = sparsity1;
%         spartab(2, k, i) = sparsity2;
%         spartab(3, k, i) = sparsity3;
%     end
% end
% 
% avetime = mean(timetab, 3);
% aveiter = mean(itertab, 3);
% avespar = mean(spartab, 3);
% 
% figure(1);clf;
% set(0,'defaultaxesfontsize',15, ...
%    'defaultaxeslinewidth',0.7, ...
%    'defaultlinelinewidth',.8,'defaultpatchlinewidth',0.8);
% set(0,'defaultlinemarkersize',10)
% shapes = {'*', 'v', '^', '+', 'o', 'x'};
% subplot(1, 3, 1);
% for i = [1 : 3]
%     plot(xvalues, avetime(i, :), ['-', shapes{i}]); hold on
% end
% xlabel(xl); ylabel('time');
% legend('IRPG-G', 'IRPG-U', 'IRPG-L'); %RPG-Ada
% 
% subplot(1, 3, 2);
% for i = [1 : 3]
%     plot(xvalues, aveiter(i, :), ['-', shapes{i}]); hold on
% end
% xlabel(xl); ylabel('iter');
% legend('IRPG-G', 'IRPG-U', 'IRPG-L');
% 
% subplot(1, 3, 3);
% for i = [1 : 3]
%     plot(xvalues, avespar(i, :), ['-', shapes{i}]); hold on
% end
% xlabel(xl); ylabel('sparsity');
% legend('IRPG-G', 'IRPG-U', 'IRPG-L');
% 
% function str = outputfloat(x)
%     if(x <= 0)
%         sn = '-';
%         x = abs(x);
%     else
%         sn = '';
%     end
%     p = log(x)/log(10);
%     p = - ceil(-p);
%     x = round(x * 10^(-p) * 100);
%     x = x / 100;
%     strx = sprintf('%3.2f', x);
%     if(p ~= 0)
%         str = [sn strx '_{' num2str(p) '}'];
%     else
%         str = [sn strx];
%     end
% end

