/*
This file is the driver for problem defined by Julia functions.
The Julia driver "DriverOPT.m" creates function handles of a cost function and
parameters for both solvers and manifolds, which are passing to the
binary file generated by this C++ driver.

---- WH
*/

#ifndef DRIVERJULIAPROB_H
#define DRIVERJULIAPROB_H

#include <iostream>
#include "Others/randgen.h"
#include "Manifolds/Manifold.h"
#include "Problems/Problem.h"
//#include "Problems/SphereTxRQ/SphereTxRQ.h"
#include "Solvers/SolversSMLS.h"
#include <ctime>

#include "Manifolds/Euclidean.h"
//#include "Manifolds/Euclidean/EucVariable.h"

//#include "Manifolds/Stiefel/StieVector.h"
//#include "Manifolds/Stiefel/StieVariable.h"
//#include "Manifolds/Stiefel/Stiefel.h"

/*Linesearch based solvers*/
#include "Solvers/RSD.h"
#include "Solvers/RNewton.h"
#include "Solvers/RCG.h"
#include "Solvers/RBroydenFamily.h"
#include "Solvers/RWRBFGS.h"
#include "Solvers/RBFGS.h"
#include "Solvers/LRBFGS.h"
#include "Solvers/RGS.h"
#include "Solvers/LRBFGSSub.h"
#include "Solvers/RBFGSSub.h"
#include "Solvers/IRPG.h"
#include "Solvers/IARPG.h"

/*Trust-region based solvers*/
#include "Solvers/SolversSMTR.h"
#include "Solvers/RTRSD.h"
#include "Solvers/RTRNewton.h"
#include "Solvers/RTRSR1.h"
#include "Solvers/LRTRSR1.h"

#include "Others/def.h"

#include "Manifolds/CFixedRankQ2F.h"
#include "Manifolds/CStiefel.h"
#include "Manifolds/CSymFixedRankQ.h"
#include "Manifolds/Euclidean.h"
#include "Manifolds/FixedRankE.h"
#include "Manifolds/FixedRankQ2F.h"
#include "Manifolds/Grassmann.h"
#include "Manifolds/SPDManifold.h"
#include "Manifolds/Sphere.h"
#include "Manifolds/Stiefel.h"
#include "Manifolds/SymFixedRankQ.h"

#ifdef DRIVERJULIAPROB

#include "Problems/juliaProblem.h"

#include "julia.h"

using namespace ROPTLIB;

struct FunHandles {
    const char *fname;
    const char *gfname;
    const char *hfname;
    const char *isstopped;
    const char *LinesearchInput;
};

struct SolverParams {
    long int IsCheckParams;
    long int IsCheckGradHess;
    const char *name;
    //Solvers
    long int Stop_Criterion;
    double Tolerance;
    double Diffx;
    long int NumExtraGF;
    long int TimeBound;
    long int Min_Iteration;
    long int Max_Iteration;
    long int OutputGap;
    long int Verbose;
    //QuasiNewton
    long int isconvex;
    double nu;
    double mu;
    long int LengthSY;
    double lambdaLower;
    double lambdaUpper;
    //SolversLS
    long int LineSearch_LS;
    long int IsPureLSInput;
    double LS_alpha;
    double LS_beta;
    double Minstepsize;
    double Maxstepsize;
    double LS_ratio1;
    double LS_ratio2;
    double Initstepsize;
    double Accuracy;
    double Finalstepsize;
    long int Num_pre_funs;
    long int InitSteptype;
    //SolversTR
    double Acceptence_Rho;
    double Shrinked_tau;
    double Magnified_tau;
    double minimum_Delta;
    double maximum_Delta;
    long int useRand;
    long int Max_Inner_Iter;
    long int Min_Inner_Iter;
    double theta;
    double kappa;
    double initial_Delta;
    //SolversLSLPSub
    double Eps;
    double Theta_eps;
    double Min_Eps;
    double Del;
    double Theta_del;
};

struct ManiParams {
    long int IsCheckParams;
    long int numoftypes;
    const char **name;
    long long *numofmani;
    long long *paramset;
    long long *m;
    long long *n;
    long long *p;
};

/*This function checks the number and formats of input parameters.
nlhs: the number of output in mxArray format
plhs: the output objects in mxArray format
nrhs: the number of input in mxArray format
prhs: the input objects in mxArray format */
//double *DriverJuliaProb(const char *fname, const char *gfname, const char *hfname, const char *isstopped, const char *LSinput, const char *solvername, double *paramsvalues, long int lengthSParams);
double *DriverJuliaProb(const char *fname, const char *gfname, const char *hfname, const char *isstopped, const char *LSinput, /*Handles*/
                        const char *solvername, double *paramsvalues, long long lengthSParams, /*Sparams*/
                        const char *maninames, long long numoftypes, long long *numofmani, long long *paramset, long long *ms, long long *ns, long long *ps, long long IsCheckParams,
                        long long inHasHHR, double *X0, integer length_X0);

/*This file creates a C++ solver based on the input parameters and run the solver to obtain a solution.*/
double *ParseSolverParamsAndOptimizing(struct SolverParams *Sparams, struct FunHandles *Handles, Problem *Prob, Variable *initialX);

/*This file creates all components of the product manifolds. Note that the cost function is always
defined on a product manifolds.*/
bool ParseManiParams(struct ManiParams *Mparams, Manifold **&manifolds, integer &numoftype, integer *&powsinterval);

/*Create a manifold based on the parameters.*/
Manifold *GetAManifold(const char *name, integer n, integer m, integer p = 1);

///*Create an element based on the parameters. Note that the element is a component of the initial iterate.*/
//Element *GetAnElement(const char *name, integer n, integer m, integer p = 1);


namespace RJULIA{
    extern jl_function_t *isstopped;
    /*This function defines the stopping criterion that may be used in the C++ solver*/
    bool juliaInnerStop(const Variable &x, const Vector &funSeries, integer lengthSeries, realdp ngf, realdp ngf0, const Problem *prob, const Solvers *solver);
    extern jl_function_t *LinesearchInput;
    /*This function defines the line search algorithm that may be used in the C++ solver*/
    double juliaLinesearchInput(integer iter, const Variable &x1, const Vector &eta1, realdp initialstepsize, realdp initialslope, const Problem *prob, const Solvers *solver);
};

#endif // end of DRIVERJULIAPROB

#endif // end of DRIVERMEXPROB_H
