function toFill_for_copy = graphcut(Hp,Hq,toFill,size_overlap,img,isRGB)
% Use graph cut algorithm to determine the region to copy pixel values.
%
% Input:
%   Hp:             current patch
%   Hq:             candidate patch
%   toFill:         missing part of Hp
%   size_overlap:   width of the overlapping region (default 1/4 of the patch size)
%   isRGB:          Whether it is an RGB image flag. 1 means rgb; 0 means gray.
% 
% Output:
%   toFill_for_copy: the region where the candidate patch pixel values are used.
% 

[m,n] = size(toFill);
overlap = false(m,n);
cost = zeros(m,n);  
node_num = zeros(m,n); % The numbering matrix of the nodes


% Identify overlapping region and number nodes.
node_count=0;
for i =1:m
    for j = 1:n 
        if ismember(1,toFill(max(1,i-size_overlap):min(m,i+size_overlap),max(1,j-size_overlap):min(n,j+size_overlap))) && toFill(i,j)==0
            overlap(i,j) = 1;
            node_count = node_count+1;
            node_num(i,j) = node_count;
        end
    end
end

% Calculate the cost between Hp and Hq in the overlapping region
if isRGB == 1
    for i=1:3
        temp = img(:,:,i);
        cost = cost+(temp(Hp)-temp(Hq)).^2;
    end
else
    temp = img;
    cost = cost+(temp(Hp)-temp(Hq)).^2;
    cost = sqrt(cost);
end


datacost = zeros(2,node_count);
smoothcost = zeros(node_count);


for i=1:m
    for j=1:n
        if overlap(i,j)
            if ismember(0,overlap(max(1,i-1):min(m,i+1),max(1,j-1):min(n,j+1)))  
                if ismember(1,toFill(max(1,i-1):min(m,i+1),max(1,j-1):min(n,j+1)))
                    datacost(2,node_num(i,j)) = inf;
                else
                    datacost(1,node_num(i,j)) = inf;
                end
            end
            if j<n && overlap(i,j+1)
                smoothcost(node_num(i,j),node_num(i,j+1)) = cost(i,j)+cost(i,j+1);
            end
            if i<m && overlap(i+1,j)
                smoothcost(node_num(i,j),node_num(i+1,j)) = cost(i,j)+cost(i+1,j);
            end
        end
    end
end

% Call minimum cut algorithm to solve
h = BK_Create(node_count);
BK_SetUnary(h,datacost); % add datacost
BK_SetNeighbors(h,smoothcost); % add smoothcost
BK_Minimize(h);
L = BK_GetLabeling(h);

% According to the results of the minimum cut algorithm, the regions that 
% need to use the pixel values of candidate patches are determined 
toFill_for_copy = toFill;
for i = 1:length(L)
    if L(i)==1
        toFill_for_copy(node_num==i) = 1;
    end
end

end

