% This script computes quantitative index of experiment results in 
% subsection 5.2, including PSNR, SSIM and FSIM.

clear;
clc;

TestMethod = 'IARPG';
TestMethod = 'LADM';




GTFileName = ['..\..\..\data\artificial_image\image.png'];            % known image file name
MaskFileName = ['..\..\..\data\artificial_image\mask.png'];           % mask file name
ResultFileName = ['..\..\..\experiment5.2\artificial_image\result\',TestMethod,'\',TestMethod,'.png'];     % output image file name (in png format)


GT = imread(GTFileName);
result = imread(ResultFileName);
Mask = imread(MaskFileName);
result(~Mask) = GT(~Mask);

SSIM=ssim(result,GT)
PSNR=psnr(result,GT)
FSIM=FeatureSIM(result,GT)