rng('default');
% seed = floor(rand() * 100000);
seed = 20;
rng(seed);

height = 320;
sub_height = 32;

a = zeros(height);

for i =1:10
    if mod(i,2)==1
        for j = 1:2:9
            a((i-1)*sub_height+1:i*sub_height, (j-1)*sub_height+1:j*sub_height) = 255;
        end
    else
        for j = 2:2:10
            a((i-1)*sub_height+1:i*sub_height, (j-1)*sub_height+1:j*sub_height) = 255;
        end
    end
end

image_file_name = '../../../data/artificial_image/image.png';
imshow(uint8(a))
imwrite(uint8(a), image_file_name)

% make block mask
rate = 0.5;
row_pix = round(sqrt(rate)*height);
mask = zeros(height);
mask(round(height/2-row_pix/2+1):round(height/2+row_pix/2), round(height/2-row_pix/2+1):round(height/2+row_pix/2))=255;
mask_file_name = '../../../data/artificial_image/mask.png';
imshow(uint8(mask))
imwrite(uint8(mask), mask_file_name)

