% This script computes quantitative index of experiment results in 
% subsection 5.3, including PSNR, SSIM, FSIM, rank and sparsity.

clear;
clc;

TestMethod = 'IARPG';
% TestMethod = 'LADM';


MissingType = 'R';  % random corruption
% MissingType = 'S';  % random small block
% MissingType = 'M';  % random medium blocks
% MissingType = 'L';  % large central blocks

if strcmp(MissingType,'R')
    MissingRate = 0.4:0.1:0.7;
else
    MissingRate = 0.1:0.1:0.2;
end

for rate = MissingRate
    index = round(rate*10);
    SSIM = zeros(112,1);
    PSNR = zeros(112,1);
    FSIM = zeros(112,1);
    Rank = zeros(112,1);
    Sparsity = zeros(112,1);

    parfor i = 1:112
        if i==14 % the 14th image is not in the database
            continue;
        end

        GTFileName = ['..\..\..\data\texture_database\D',num2str(i),'.png']; % original image file name
        if strcmp(MissingType,'L')
            MaskFileName = ['..\..\..\data\mask_',MissingType,'\M',num2str(rate),'.png']; % mask file name
        else
            MaskFileName = ['..\..\..\data\mask_',MissingType,'\',num2str(rate),'\M',num2str(i),'.png']; 
        end
        ResultFileName_mat = ['..\..\..\experiment5.3\texture_database\result\',MissingType,'\',TestMethod,'\mat\',num2str(rate),'\',TestMethod,num2str(i),'.mat']; % output (mat format is used to calculate rank and sparsity) file name
        ResultFileName = ['..\..\..\experiment5.3\texture_database\result\',MissingType,'\',TestMethod,'\png\',num2str(rate),'\',TestMethod,num2str(i),'.png']; % output (png format is used to calculate PSNR, SSIM ans FSIM) file name


        GT = imread(GTFileName);
        result = imread(ResultFileName);
        soure_data = load(ResultFileName_mat);
        % resultDirect = soure_data.rA;
        resultDirect = soure_data.X;
        Mask = imread(MaskFileName);
        result(~Mask) = GT(~Mask);

        SSIM(i)=ssim(result,GT);
        PSNR(i)=psnr(result,GT);
        FSIM(i)=FeatureSIM(result,GT);
        Rank(i)=our_rank(resultDirect);
        Sparsity(i)=our_sparsity(resultDirect);

    end
    average_ssim(index) = sum(SSIM)/sum((SSIM~=0));
    average_psnr(index) = sum(PSNR)/sum((SSIM~=0));
    avsrage_FSIM(index) = sum(FSIM)/sum((SSIM~=0));
    avsrage_rank(index) = sum(Rank)/sum((SSIM~=0));
    avsrage_sparsity(index) = sum(Sparsity)/sum((SSIM~=0));
    
end
average_psnr
average_ssim
avsrage_FSIM
avsrage_rank
avsrage_sparsity

function r = our_rank(I)
% calculates the rank of the output
normI = norm(I);
I = idct2(I);
I = I /normI;
r = sum(svd(I) > 1e-6);
end

function sparsity = our_sparsity(I)
% calculate the sparsity of the output
normI = norm(I);
I = idct2(I);
I = I /normI;
sparsity = sum(sum(abs(I) < 1e-4)) / numel(I);
end