% This script computes quantitative index of experiment results in 
% subsection 5.4, including PSNR, SSIM and FSIM.

clear;
% clc;

% select test method
TestMethod = 'Integration';
TestMethod = 'IARPG';


% select missing type
MissingType = 'S';  % random small block
% MissingType = 'M';  % random medium blocks
% MissingType = 'L';  % large central blocks

% select missing type
MissingRate = 0.1:0.1:0.2;

% id = [1,3,6,8,11,16,17,20,34,35,36,46,47,48,49,50,51,52,53,55,56,64,65,68,76,77,78,79,80,81,82,83,84,85,94,95,96,101,102,105,106]; % more regular textures

for rate = MissingRate
    index = round(rate*10);
    SSIM = zeros(112,1);
    PSNR1 = zeros(112,1);
    FSIM = zeros(112,1);


    for i = 112
        if i==14 % the 14th image is not in the database
            continue;
        end

        GTFileName = ['..\..\..\data\texture_database\D',num2str(i),'.png']; % original image file name
        if strcmp(MissingType,'L')
            MaskFileName = ['..\..\..\data\mask_',MissingType,'\M',num2str(rate),'.png']; % mask file name
        else
            MaskFileName = ['..\..\..\data\mask_',MissingType,'\',num2str(rate),'\M',num2str(i),'.png']; 
        end
        ResultFileName = ['..\..\..\experiment5.4\texture_database\result\',MissingType,'\',TestMethod,'\',num2str(rate),'\',TestMethod,num2str(i),'.png']; % output (png format is used to calculate PSNR, SSIM ans FSIM) file name



        GT = imread(GTFileName);
        result = imread(ResultFileName);
        Mask = imread(MaskFileName);
        result(~Mask) = GT(~Mask);


        SSIM(i)=ssim(result,GT);
        PSNR1(i)=psnr(result,GT);
        FSIM(i)=FeatureSIM(result,GT);

    end
    average_ssim(index) = sum(SSIM)/sum((SSIM~=0));
    average_psnr(index) = sum(PSNR1)/sum((SSIM~=0));
    avsrage_FSIM(index) = sum(FSIM)/sum((SSIM~=0));
    
end
average_psnr
average_ssim
avsrage_FSIM
