% This is the main program of our proposed integration algorithm. 
% Once you have set the storage path of the input image, mask and output 
% result, you can run this code to complete your own image.

clear;
clc;

%%  Select the test image and mask set the path for saving the output result

InputFileName =  ['data\user_data\image1.png']; % known image file name
MaskFileName = ['data\user_data\mask1.png']; % mask file name
AfterIARPGimgFilename = ['data\user_data\IARPG1.png']; % the path to the IARPG method (i.e. first stage) results
FinalOutputFileName = ['data\user_data\Integration1.png']; % the path to the integration method results

%% Set up required path
ImportDIR;

%% Set random seeds.
rng('default');
% seed = floor(rand() * 100000);
seed = 20;
rng(seed);

%% Stage 1: IARPG 
OriginalImage = double(imread(InputFileName));
Mask = imbinarize(imread(MaskFileName));

tic;

E = zeros(size(OriginalImage));
rA = zeros(size(OriginalImage));
normA = zeros(3,1);
Dam = zeros(size(OriginalImage));
r_RGB = zeros(3,1);
for i=1:3 % RGB channel

    A = OriginalImage(:,:,i);
    E(:,:,i) = A;


    normA(i) = norm(A);
    A = A / normA(i);
    [m, n] = size(A);

    % determine r
    t1 = 0.2;
    t2 = 0.995;

    A(Mask) = sum(A(:))/sum(sum(~Mask));
    [U, D, V] = svd(A);

    diagD = diag(D);
    normD = sqrt(sum(diagD.^2));
    for r = 1:min(m,n)
        if sqrt(sum(diagD(1:r).^2))/normD >= t2
            break;
        end
    end
    r_max = floor(t1*min(m,n));
    r = min(r,r_max);

    r_RGB(i)=r;


    A(Mask)=0;
    Dam(:,:,i) = A*normA(i);


    U = U(:, 1:r);
    D = D(1:r, 1:r);
    V = V(:, 1:r);

    %     U = orth(randn(m, r));
    %     D = randn(r, r);
    %     V = orth(randn(n, r));
    Xinitial.main = U * D * V';
    Xinitial.U = U;
    Xinitial.D = D;
    Xinitial.V = V;
    type = 2;
    LADMmu = 0.1;
    LADMrho = 1.1;
    LADMeta = 3;


    %method: 1: AManPG, 2: LADM
    method = 1;
    lambda = 0.0008; % default

    %     method = 2;
    %     lambda = 0.003;


    SolverParams.method = 'IARPG'; % IRPG IARPG
    SolverParams.IsCheckParams = 1;
    %     SolverParams.RPGVariant = 0; %0: RPG without adaptive stepsize, 1: RPG with adaptive stepsize
    SolverParams.LengthW = 1;
    SolverParams.OutputGap = 10;
    SolverParams.Max_Iteration = 500;
    % SolverParams.SMtol = 1e-2;
    SolverParams.Stop_Criterion = 3;
    SolverParams.Tolerance = 1e-3;
    %     SolverParams.Min_Iteration = 10;
    SolverParams.Verbose = 2;

    [xopt1] = TestFRankETextureInpainting(sparse(A), lambda, Xinitial, type, method, SolverParams, LADMmu, LADMrho, LADMeta);

    xopt1.main = xopt1.main * normA(i);
    %     svd(xopt1.main)'
    rA(:,:,i) = dct2(xopt1.main);
    temp_rA =  rA(:,:,i);
    temp_E = E(:,:,i);
    temp_E(Mask) = temp_rA(Mask);
    E(:,:,i)=temp_E;
end
imwrite(uint8(E),AfterIARPGimgFilename);

time_iarpg = toc;
fprintf('The IARPG algorithm ends, taking %.2f seconds.\n',time_iarpg);

%% Stage 2: exemplar-based method


HalfPatchSize = 4; % i.e. default patch size is 9×9
UseGraphcut = 1; % i.e. use graphcut

[inpaintedImg,origImg,C,D,fillMovie] = inpaint_2nd_rgb(AfterIARPGimgFilename,MaskFileName,HalfPatchSize,UseGraphcut);
imwrite(uint8(inpaintedImg),FinalOutputFileName);
time_total = toc;
fprintf('The Integration algorithm ends, taking %.2f seconds in total.\n',time_total);

%% Show the results visualize completion process

figure(1);
subplot(1,4,1);
imshow(uint8(OriginalImage))
title('Original Image')
subplot(1,4,2)
imshow(uint8(Dam));
title('Damged image');
subplot(1,4,3)
imshow(uint8(E));
title('IARPG Result');
subplot(1,4,4)
imshow(uint8(inpaintedImg));
title('Integration Method Result');

figure(2)
movie(gcf,fillMovie);
