function output = testSimpleExample()
n = 5;
p = 2;
B = randn(n, n); B = B + B';
D = sparse(diag(p : -1 : 1));
fhandle = @(x)f(x, B, D);
gfhandle = @(x)gf(x, B, D);
Hesshandle = @(x, eta)Hess(x, eta, B, D);

SolverParams.method = 'RSD';
SolverParams.IsCheckParams = 1;
SolverParams.DEBUG = 1;
% SolverParams.IsCheckGradHess = 1;

ManiParams.IsCheckParams = 1;
ManiParams.name = 'Stiefel';
ManiParams.n = n;
ManiParams.p = p;
ManiParams.ParamSet = 1;
HasHHR = 0;

initialX.main = orth(randn(n, p));

output = DriverOPT(fhandle, gfhandle, Hesshandle, SolverParams, ManiParams, HasHHR, initialX);
end

function [output, x] = f(x, B, D)
x.BUD = B * x.main * D;
output = x.main(:)' * x.BUD(:);
end

function [output, x] = gf(x, B, D)
output.main = 2 * x.BUD;
end

function [output, x] = Hess(x, eta, B, D)
output.main = 2 * B * eta.main * D;
end

% function [output, x] = f(x, B)
% U = reshape(x.main, 5, 2);
% x.BU = B * U;
% output = trace(U' * x.BU);
% x.BU = reshape(x.BU, [], 1);
% end
% 
% function [output, x] = gf(x, B)
% U = reshape(x.main, 5, 2);
% BU = reshape(x.BU, 5, 2);
% output.main = reshape(2 * BU, [], 1);
% end
% 
% function [output, x] = Hess(x, eta, B)
% output.main = reshape(2 * B * reshape(eta.main, 5, 2), [], 1);
% end
