
#include "TestProduct.h"

#if !defined(MATLAB_MEX_FILE) && defined(TESTPRODUCT)

std::map<integer *, integer> *CheckMemoryDeleted;

int main(void)
{
	init_genrand(0);

	CheckMemoryDeleted = new std::map<integer *, integer>;

	testProduct();
	std::map<integer *, integer>::iterator iter = CheckMemoryDeleted->begin();
	for (iter = CheckMemoryDeleted->begin(); iter != CheckMemoryDeleted->end(); iter++)
	{
		if (iter->second != 1)
			std::cout << "Global address:" << iter->first << ", sharedtimes:" << iter->second << std::endl;
	}
	delete CheckMemoryDeleted;

#ifdef _WIN64
#ifdef _DEBUG
	_CrtDumpMemoryLeaks();
#endif
#endif
	return 0;
}
#endif

#ifdef MATLAB_MEX_FILE

std::map<integer *, integer> *CheckMemoryDeleted;

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
	init_genrand(0);

	CheckMemoryDeleted = new std::map<integer *, integer>;
	testProduct();
	std::map<integer *, integer>::iterator iter = CheckMemoryDeleted->begin();
	for (iter = CheckMemoryDeleted->begin(); iter != CheckMemoryDeleted->end(); iter++)
	{
		if (iter->second != 1)
			std::cout << "Global address:" << iter->first << ", sharedtimes:" << iter->second << std::endl;
	}
	delete CheckMemoryDeleted;
	return;
}

#endif

void testProduct(void)
{
	integer n = 3, p = 2, m = 2;
	integer numofmanis = 2;
	integer numofmani1 = 1;
	integer numofmani2 = 1;

	StieVariable StieX(n, p);
	StieX.RandInManifold();
	EucVariable EucX(m);
	EucX.RandInManifold();

	//ProductElement ProdX(numofmanis);
	//ProdX.AddElement(&StieX, 0);
	//ProdX.AddElement(&EucX, 1);

	// Another way to construct a variable of product manifold
	//Variable **vars = new Variable *[2];
	//vars[0] = &StieX;
	//vars[1] = &EucX;
	ProductElement ProdX(numofmanis, &StieX, numofmani1, &EucX, numofmani2);
	ProdX.RandInManifold();
	//delete[] vars;
	//ProdX.Print("ProdX:");

	//ProductElement *ProdXptr = ProdX.ConstructEmpty();
	//ProdX.CopyTo(ProdXptr);
	//ProdXptr->Print("ptr:");

	//delete ProdXptr;

	Stiefel mani1(n, p);
	Euclidean mani2(m);
	ProductManifold ProdMani(numofmanis, &mani1, numofmani1, &mani2, numofmani2);
	ProdMani.SetHasHHR(true);

	ProdMani.CheckIntrExtr(&ProdX);
	ProdMani.CheckRetraction(&ProdX);
	ProdMani.CheckDiffRetraction(&ProdX);
	ProdMani.CheckLockingCondition(&ProdX);
	ProdMani.CheckcoTangentVector(&ProdX);
	ProdMani.CheckIsometryofVectorTransport(&ProdX);
	ProdMani.CheckIsometryofInvVectorTransport(&ProdX);
	ProdMani.CheckVecTranComposeInverseVecTran(&ProdX);
	ProdMani.CheckTranHInvTran(&ProdX);
	ProdMani.CheckHaddScaledRank1OPE(&ProdX);
};
