function MTestSPDTensorDL()
    r = floor(rand() * 10000000);
%     r = 268764
%     r = 7740966
    rand('state', r);
    randn('state', r);
    dim = 5;
    num = 20;
    N = 1;
    
    alphatrue = rand(num, N);
    alphainit = rand(num, N) * 1e-1;
    
    Bs = zeros(dim, dim, num);
    for i = 1 : num
        tmp = randn(dim, dim * 10);
        Bs(:, :, i) = tmp * tmp';
    end
    Balpha = reshape(reshape(Bs, dim * dim, num) * alphatrue, dim, dim, N);
    
    Ls = zeros(dim, dim, N);
    for i = 1 : N
        Ls(:, :, i) = chol(Balpha(:, :, i), 'lower');
    end
    
    SolverParams.method = 'LRBFGS';
    SolverParams.IsCheckParams = 1;
    SolverParams.Max_Iteration = 100;
    SolverParams.OutputGap = 1;
    SolverParams.LengthSY = 4;
    SolverParams.Num_pre_funs = 0;
    SolverParams.InitSteptype = 3;
    SolverParams.DEBUG = 2;
    SolverParams.Stop_Criterion = 2;
%     SolverParams.IsCheckGradHess = 1;
    HasHHR = 0;
    [Xopt, f, gf, gfgf0, iter, nf, ng, nR, nV, nVp, nH, ComTime] = TestEucPosSpCd(Ls, Bs, alphainit, 0, HasHHR, SolverParams);
    
%     SolverParams.method = 'RSD';
%     SolverParams.IsCheckParams = 1;
%     SolverParams.Max_Iteration = 200;
%     SolverParams.OutputGap = 10;
%     SolverParams.LengthSY = 4;
%     SolverParams.Num_pre_funs = 0;
%     SolverParams.InitSteptype = 3;
%     SolverParams.DEBUG = 2;
%     SolverParams.Stop_Criterion = 2;
% %     SolverParams.IsCheckGradHess = 1;
%     HasHHR = 0;
%     [Xopt, f, gf, gfgf0, iter, nf, ng, nR, nV, nVp, nH, ComTime] = TestEucPosSpCd(L, Bs, alphainit, 0, HasHHR, SolverParams);
end
