function fs = choose_manifold(manifold, retraction, vector_transport)
% this function return some necessary function handles of some manifolds which are required in RBroydenFamily code.
% Input:
% Some examples of manifold. For each manifold, some retractions and vector transport are provided here.
%     params.manifold : the manifold which objective function is on.
%         '1', sphere : S^{n - 1}
%             params.retraction : 
%                 '1', exponential mapping
%                 '2', R_x(eta) = (x + eta) / norm(x + eta)
%             params.vector_transport : the isometric vector transport
%                 '1', parallel transport
%                 '2', isometric vector transport (canonical angles)
%         '2', Stiefel manifold : St(p, n)
%             params.retraction : 
%                 '1', exponential mapping when it is considered as Quotient space
%                 '2', exponential mapping when it is considered as Embedding space
%                 '3', qf factorization : qf(X + eta)
%             params.vector_transport : the isometric vector transport
%                 '1', parallel transport when it is considered as Quotient space (the retraction must be 1)
%                 '2', parallel transport when it is considered as Embedding space (the retraction must be 2)
%                 '3', isometric vector transport by method 2 in RBroydenFamily paper when retraction is qf. (the retraction must be 3)
% output:
%     fns.inpro(x, v1, v2) : return the inner product g_x(v1, v2) of two tangent vectors v1 and v2 on T_x M.
%     fns.Hv(x, H, v) : return tangent vector which is given by that operator H affect on tangent vector v on T_x M.
%     fns.invBv(x, B, v) : return a tangent vector vv on T_x M which satisfies B vv = v.
%     fns.phi() : return the coefficient of RBroyden Family update formula.
%     fns.proj(x, eta) : return P_x(eta) by projecting v to tangent space of x.
%     fns.SRTV(x, m) : return m random tangent vectors in T_x M.
%     fns.R(x, eta) : return R_x(eta), where R is a retraction, x is an element on the manifold and eta is a tangent vector of T_x M.
%     fns.beta(x, eta) : return \|eta\| / \|TR_eta (eta)\|, where TR is the differentiated retraction.
%     fns.Tranv(x1, d, x2, v) : return a tangent vector on T_x2 M, which is given by vector transport that transport v \in T_x M to T_{R_x(d)} M. Here x2 = R_x(d).
%     fns.invTranv(x1, d, x2, v) : return a tangent vector on T_x1 M, which is given by inverse vector transport that transport v \in T_x2 M to T_x1 M. Here x2 = R_x1(d).
%     fns.TranH(x1, d, x2, H1) : return a operator, H2, that affects on T_x2 M. H2 satisfies that for any v \in T_x2(M), H2(v) = Tran (H1 (Tran^{-1}(v)))
%                             where Tran is the vector transport fns.Tranv(x1, d, x2, v).
%     fns.rank1operator(x, v1, v2) : return a operator, H, on T_x M that satisfies that for any v \in T_x M, H(v) = g_x(v2, v) * v1.
%     fns.operadd(x, H1, H2) : return a operator, H, on T_x M that satisfies that for any v \in T_x M, H(v) = H1(v) + H2(v).

    if(manifold == 1)
        fs = sphere(retraction, vector_transport);
    end

    if(manifold == 2)
        fs = stiefel(retraction, vector_transport);
    end
    
    if(manifold == 3)
        fs = orthogroup(retraction, vector_transport);
    end
    
    if(manifold == 4)
        fs = grassmann(retraction, vector_transport);
    end
end
