function [X, F, G, T, timecost, nf, ng, nR, nH, nV, nVp] = driver_RQ(A, method, fns, params)
% driver for Rayleigh Quotient minimization.
% x^* = arg min_{x in S^{n - 1}} x^T A x, where A is a n by n symmetric matrix.
    fns.f = @(x)f(x, A);
    fns.gf = @(x)gf(x, A);
    fns.gf_exists = @(x)gf_exists(x, A);
    fns.hessianv = @(x, v)hessianv_newton(x, v, A);

    nH = 0;
    nV = 0;
    nVp = 0;
    if(method == 1)
        [X, F, G, timecost, nf, ng, nH, T, nV, nR] = RTR_SR1(fns, params);
    elseif(method == 2)
        [X, F, G, timecost, nf, ng, T, nV, nVp, nR] = LRTR_SR1(fns, params);
    elseif(method == 3)
        [X, F, G, timecost, nf, ng, T, nR] = RTR_SD(fns, params);
    elseif(method == 4)
        [X, F, G, timecost, nf, ng, nH, T, nR] = rtr(fns, params);
    end
end

function output = f(x, A)
    output = x' * (A * x);
end

function output = gf(x, A)
    temp = A * x;
%     output = 2 * (eye(size(x, 1)) - x * x') * temp; %% small numerical error but slow
    output = 2 * (temp - x * (x' * temp)); %% big numerical error, but fast
end

function output = gf_exists(x, A)
    output = 1;
end

function output = hessianv_newton(x, w, A)
  % The hessian
   xtax = x'*(A*x);
   temp = (A*w-w*xtax);
   output =2*(temp-x*(x'*temp));
end
