function params = set_default_para(params, name, default_value, type, a, b)
    if(~isfield(params, name))
        params = setfield(params, name, default_value);
    end
    value = getfield(params, name);

    if(strcmp(type, 'int') && round(value) ~= value)
        msg = sprintf('Invalid arguments: params.%s must be a integer', name);
        error(msg);
    end
    
    if(value < a || value > b)
        msg = sprintf('Invalid arguments: params.%s must be in [%d, %d]', name, a, b);
        error(msg);
    end
end
