function generate_table()
    tab = zeros(18, 10);
    m = 0;
    for i = 1 : 3
        N = 16 * 4^i;
        n=N;
        r = 1;
        rand('state', r);
        randn('state', r);
        Lambda = diag([0, linspace(0.01, 0.01, floor((n - 1)/2)), linspace(2, 2, n-1 - floor((n - 1)/2))]);

        Q = orth(randn(n, n));
        A = Q * Lambda * Q';
        x1 = randn(n, 1);
        x1 = x1 / norm(x1);
    
        for j = 1 : 5
            if(j == 1)
                method = 4;
            elseif(j == 2)
                method = 1;
            else
                method = 2;
                if(j == 3)
                    m = 0;
                elseif(j == 4)
                    m = 2;
                else
                    m = 4;
                end
%                 m = 2^(j - 2);
            end
            for k = 1 : 2
                if(k == 1)
                    tol = 1e-3;
                else
                    tol = 1e-6;
                end
                [iter, ng, nH, gff, gff0, t] = test_RQ(A, x1, N, method, m, tol);
                tab((i - 1) * 6 + 1, (j - 1) * 2 + k) = iter;
                tab((i - 1) * 6 + 2, (j - 1) * 2 + k) = ng;
                tab((i - 1) * 6 + 3, (j - 1) * 2 + k) = nH;
                tab((i - 1) * 6 + 4, (j - 1) * 2 + k) = gff;
                tab((i - 1) * 6 + 5, (j - 1) * 2 + k) = gff0;
                tab((i - 1) * 6 + 6, (j - 1) * 2 + k) = t;
            end
        end
    end
    fout = fopen('tex_RQ_tab.txt','w');
    for k = 0 : 2
        for i = k*6+1 : k*6+3
            for j = 1 : 10
                if(j < 10)
                    fprintf(fout,'%d & ',tab(i, j));
                else
                    fprintf(fout,'%d',tab(i, j));
                end
            end
            fprintf(fout,' \\\\\n');
        end
        for i = k*6+4 : k*6+6
            for j = 1 : 10
                str = outputfloat(tab(i, j));
                if(j < 10)
                    fprintf(fout,['$' str '$ & ']);
                else
                    fprintf(fout,['$' str '$ ']);
                end
            end
            fprintf(fout,' \\\\\n');
        end
    end
    
    fclose(fout);
end

function str = outputfloat(x)
    if(x <= 0)
        str = '';
        return;
    end
    p = log(x)/log(10);
    p = - ceil(-p);
    x = round(x * 10^(-p) * 100);
    x = x / 100;
    strx = sprintf('%3.2f', x);
    if(p ~= 0)
        str = [strx '_{' num2str(p) '}'];
    else
        str = strx;
    end
end

function [iter, ng, nH, gff, gff0, t] = test_RQ(A, x1, n, method, m, tol)
    fprintf('test for Rayleigh Quotient minimization. \n');
    fprintf('x^* = arg min_{x in S^{n - 1}} x^T A x, where A is a n by n symmetric matrix. \n');
    r = rand();
    r = floor(r * 10000);
    r = 1;
    rand('state', r);
    Retraction = 2;
    VT = 1;
    LC_M = [1, 1, 0, 0;
            1, 1, 0, 0;];
    if(method <= 4 && ~LC_M(Retraction, VT))
        fprintf('Locking condition is not satisfied. Algorithm may fail. \n')
        fprintf('Do you still want to run it? \n')
        fprintf('1: run \n')
        fprintf('otherwise: exit \n')
        flag = input('input: ');
        if(isempty(flag) || flag ~= 1)
            fprintf('exit! \n');
            return;
        end
    end
    B = eye(n);
    params.x0 = x1;
    params.B0 = B;
    params.error = tol;%%---1e-6;
    params.StopCriterion = 3;
    params.max_t = 1000;
    params.max_outer = params.max_t;
    params.debug = 0;
    params.manifold = 1;
    params.m = m;
    params.alpha = 1e-4;
    params.beta = 0.999;
    params.minstepsize = 1e-4;
    params.maxstepsize = 200;
    params.Delta_bar = inf;
    params.Delta0 = 1;
    params.min_Delta = 1e-8;
    params.retraction = Retraction;
    params.vector_transport = VT;
    fns = {};
    
    times = 0;
    total_timecost = 0;
    while(total_timecost < 60 && times < 1)
        fprintf('%d: ', times);
        [X, F, G, T, timecost, nf, ng, nR, nH, nV, nVp] = driver_RQ(A, method, fns, params);
        total_timecost = total_timecost + timecost;
        times = times + 1;
    end
    fprintf('average time cost of %d times is %f. \n', times, total_timecost / times);
    iter = length(G);
    gff = G(end);
    gff0 = gff/G(1);
    t = total_timecost / times;
end
