function generate_table()
    tab = zeros(18, 10);
    m = 0;
    for i = 1 : 3
        N = 4 * 4^i;
        for j = 1 : 5
            if(j == 1)
                method = 4;
            elseif(j == 2)
                method = 1;
            else
                method = 2;
                m = 2^(j - 2);
            end
            for k = 1 : 2
                if(k == 1)
                    tol = 1e-3;
                else
                    tol = 1e-6;
                end
                [iter, ng, nH, gff, gff0, t] = test_soft_ICA(N, method, m, tol);
                tab((i - 1) * 6 + 1, (j - 1) * 2 + k) = iter;
                tab((i - 1) * 6 + 2, (j - 1) * 2 + k) = ng;
                tab((i - 1) * 6 + 3, (j - 1) * 2 + k) = nH;
                tab((i - 1) * 6 + 4, (j - 1) * 2 + k) = gff;
                tab((i - 1) * 6 + 5, (j - 1) * 2 + k) = gff0;
                tab((i - 1) * 6 + 6, (j - 1) * 2 + k) = t;
            end
        end
    end
    fout = fopen('tex_softICA_tab.txt','w');
    for k = 0 : 2
        for i = k*6+1 : k*6+3
            for j = 1 : 10
                if(j < 10)
                    fprintf(fout,'%d & ',tab(i, j));
                else
                    fprintf(fout,'%d',tab(i, j));
                end
            end
            fprintf(fout,' \\\\\n');
        end
        for i = k*6+4 : k*6+6
            for j = 1 : 10
                str = outputfloat(tab(i, j));
                if(j < 10)
                    fprintf(fout,['$' str '$ & ']);
                else
                    fprintf(fout,['$' str '$ ']);
                end
            end
            fprintf(fout,' \\\\\n');
        end
    end
    
    fclose(fout);
%     dlmwrite('tex_tab.txt', tab);
end

function str = outputfloat(x)
    if(x <= 0)
        str = '';
        return;
    end
    p = log(x)/log(10);
    p = - ceil(-p);
    x = round(x * 10^(-p) * 100);
    x = x / 100;
    strx = sprintf('%3.2f', x);
    if(p ~= 0)
        str = [strx '_{' num2str(p) '}'];
    else
        str = strx;
    end
end

function [iter, ng, nH, gff, gff0, t] = test_soft_ICA(N, method, m, tol)
    fprintf('test for soft ICA problem. \n');
    fprintf('X^* = arg min_{x in St(p, n)} - sum_{i=1}^N ||diag(Y^T C_i Y)||_F^2, where C_i are positive-semidefinite symmetric matrix. \n');
    r = rand();
    r = floor(r * 10000);
    r = 1;
    Retraction = 4;
    VT = 7;
    if(method == 4)
        VT = 4;
    end
    n = 12;
    p = 4;
    rand('state', r);
    randn('state', r);
    C = zeros(n, n, N);
    epsi = 1e-1;  % for example
     for i = 1 : N
         Temp = randn(n, n);
         C(:, :, i) = diag([n:-1:1]) + epsi * (Temp' + Temp);
         % C(:, :, i) = C(:, :, i) / norm(C(:, :, i));
     end
    
    x1 = randn(n, p);
    [x1, r] = qr(x1, 0);
    H0 = eye(n * p);
    B0 = eye(n * p);
    if(VT == 7 || VT == 13)
        d = 0.5 * p * (p - 1) + (n - p) * p;
        H0 = eye(d);
        B0 = eye(d);
        x0 = x1;
        clear('x1');
        x1{1} = x0;
        x1{2} = null(x0');
    end
    params.x0 = x1;
    params.H0 = H0;
    params.B0 = B0;
    params.error = tol;
    params.max_t = 10000;
    params.debug = 0;
    params.manifold = 2;
    params.m = m;
    params.alpha = 1e-4;
    params.beta = 0.999;
    params.min_Delta = 1e-8;
    params.minstepsize = 1e-4;
    params.maxstepsize = 200;
    params.retraction = Retraction;
    params.vector_transport = VT;
    params.Delta_bar = inf;
    params.Delta0 = 1;
    params.StopCriterion = 3;
%     params.theta = 1;
%     params.kappa = 0.1;
    params.restart = 0;
    times = 0;
    total_timecost = 0;
    while(total_timecost < 60 && times < 1)
        fprintf('%d: ', times);
        [X, F, G, T, timecost, nf, ng, nR, nH, nV, nVp] = driver_soft_ICA(C, method, params);
        total_timecost = total_timecost + timecost;
        times = times + 1;
    end
    fprintf('average time cost of %d times is %f. \n', times, total_timecost / times);

    iter = length(G);
    gff = G(end);
    gff0 = gff/G(1);
    t = total_timecost / times;
end
