function [T, G] = test_RQ(A, x1)
    fprintf('test for Rayleigh Quotient minimization. \n');
    fprintf('x^* = arg min_{x in S^{n - 1}} x^T A x, where A is a n by n symmetric matrix. \n');
    r = rand();
    r = floor(r * 10000);
    r = 1;
    rand('state', r);
    randn('state', r);
    n = 16;
    fprintf('In this case, n = %d. A and x0 are chosen randomly. Random seed is %d \n', n, r);
    fprintf('which algorithm do you want to test: \n');
    fprintf('1, RTR-SR1 \n');
    fprintf('2, LRTR-SR1 \n');
    fprintf('3, RTR-SD \n');
    fprintf('4, RTR-Newton \n');
    fprintf('otherwise, break \n');
    method = input('please input: ');
    if(method < 1 || method > 4)
        fprintf('exit! \n');
        return;
    end
    fprintf('which retraction do you want to test: \n');
    fprintf('1, exp \n');
    fprintf('2, normalized\n');
    fprintf('otherwise, break \n');
    Retraction = input('please input: ');
    if(Retraction < 1 || Retraction > 2)
        fprintf('exit! \n');
        return;
    end
    if(method == 4)
        VT = 1;
    else
        fprintf('which vector transport do you want to test: \n');
        fprintf('1, parallel \n');
        fprintf('2, reflection \n');
        fprintf('3, differentiated retraction \n');
        fprintf('4, projection \n');
        fprintf('otherwise, break \n');
        VT = input('please input: ');
        if(VT < 1 || VT > 4)
            fprintf('exit! \n');
            return;
        end
    end
    r = 1;
    rand('state', r);
    randn('state', r);
%     Lambda = diag([1, linspace(10, 10+eps_eig, n - 1)]);
    Lambda = diag(1 : n);
    
    Q = orth(randn(n, n));
    A = Q * Lambda * Q';
    x1 = randn(n, 1);
    x1 = x1 / norm(x1);

    H = eye(n);
    B = eye(n);
    params.x0 = x1;
    params.H0 = H;
    params.B0 = B;
    params.error = 1e-9;
    params.max_t = 20;
    params.max_outer = params.max_t;
    params.debug = 0;
    params.manifold = 1;
    params.m = 4;
    params.alpha = 1e-4;
    params.beta = 0.999;
    params.minstepsize = 1e-4;
    params.maxstepsize = 200;
    params.Delta_bar = inf;
    params.Delta0 = 1;
    params.min_Delta = 1e-8;
    params.retraction = Retraction;
    params.vector_transport = VT;
    fns = {};
    
    times = 0;
    total_timecost = 0;
    while(total_timecost < 60 && times < 1)
        fprintf('%d: ', times);
        [X, F, G, T, timecost, nf, ng, nR, nH, nV, nVp] = driver_RQ(A, method, fns, params);
        total_timecost = total_timecost + timecost;
        times = times + 1;
    end
    fprintf('average time cost of %d times is %f. \n', times, total_timecost / times);
end
