function [T, G] = test_soft_ICA
    fprintf('test for soft ICA problem. \n');
    fprintf('X^* = arg min_{x in St(p, n)} - sum_{i=1}^N ||diag(Y^T C_i Y)||_F^2, where C_i are positive-semidefinite symmetric matrix. \n');
    r = rand();
    r = floor(r * 10000);
    r = 1;
    fprintf('In this case, n = 5, p = 3. A B, and x0 are chosen randomly. Random seed is %d \n', r);
    fprintf('which algorithm do you want to test: \n');
    fprintf('1, RTR-SR1 \n');
    fprintf('2, LRTR-SR1 \n');
    fprintf('3, RTR-SD \n');
    fprintf('4, RTR-Newton \n');
    fprintf('otherwise, break \n');
    method = input('please input: ');
    if(method < 1 || method > 4)
        fprintf('exit! \n');
        return;
    end
    fprintf('which retraction do you want to test: \n');
    fprintf('1, parallel (quotient) \n');
    fprintf('2, parallel (embedded) \n');
    fprintf('3, qf (quotient)\n');
    fprintf('4, qf (embedded)\n');
    fprintf('otherwise, break \n');
    Retraction = input('please input: ');
    if(Retraction < 1 || Retraction > 4)
        fprintf('exit! \n');
        return;
    end
    if(method == 4)
        if(Retraction == 1 || Retraction == 3)
            VT = 12;
        else
            VT = 6;
        end
    else
        fprintf('which vector transport do you want to test: \n');
        fprintf('1, Emb&Quo nonIso: vector transport by projection \n')
        fprintf('2, Emb Iso: parallel transport \n')
        fprintf('3, Emb Iso: direct-rotation with basis on tangent space \n')
        fprintf('4, Emb Iso: direct-rotation with basis on normal space \n')
        fprintf('5, Emb Iso: smooth basis on tangent space \n')
        fprintf('6, Emb Iso: smooth basis on normal space \n')
        fprintf('7, Emb Iso: intrinsic approach \n')
        fprintf('8, Quo Iso: parallel transport \n')
        fprintf('9, Quo Iso: direct-rotation with basis on horizontal space \n')
        fprintf('10,Quo Iso: direct-rotation with basis on vertical space \n')
        fprintf('11,Quo Iso: smooth basis on horizontal space \n')
        fprintf('12,Quo Iso: smooth basis on vertical space \n')
        fprintf('13,Quo Iso: intrinsic approach \n')
        fprintf('otherwise, break \n');
        VT = input('please input: ');
        if(VT < 1 || VT > 13)
            fprintf('exit! \n');
            return;
        end
    end
    N = 256;
    n = 12;
    p = 4;
    rand('state', r);
    randn('state', r);
    C = zeros(n, n, N);
%     for i = 1 : N
%         Temp = randn(n, n);
%         C(:, :, i) = Temp' * Temp;
%         C(:, :, i) = C(:, :, i) / norm(C(:, :, i));
%     end

    epsi = 1e-1;  % for example
     for i = 1 : N
         Temp = randn(n, n);
         C(:, :, i) = diag([n:-1:1]) + epsi * (Temp' + Temp);
     end
    
    x1 = randn(n, p);
    [x1, r] = qr(x1, 0);
    H0 = eye(n * p);
    B0 = eye(n * p);
    if(VT == 7 || VT == 13 || VT == 19 || VT == 25)
        d = 0.5 * p * (p - 1) + (n - p) * p;
        H0 = eye(d);
        B0 = eye(d);
        x0 = x1;
        clear('x1');
        x1{1} = x0;
        x1{2} = null(x0');
    end
    params.x0 = x1;
    params.H0 = H0;
    params.B0 = B0;
    params.error = 1e-6;
    params.max_t = 5000;
    params.debug = 0;
    params.manifold = 2;
    params.m = 4;
    params.alpha = 1e-4;
    params.beta = 0.999;
    params.min_Delta = 1e-8;
    params.minstepsize = eps;
    params.maxstepsize = 200;
    params.retraction = Retraction;
    params.vector_transport = VT;
    params.Delta_bar = inf;
%     params.tau1 = 0.5;
    params.Delta0 = 1;
    params.StopCriterion = 3;
%     params.theta = 0.1;
%     params.kappa = 0.1;
    params.restart = 0;
    times = 0;
    total_timecost = 0;
    while(total_timecost < 60 && times < 1)
        fprintf('%d: ', times);
        [X, F, G, T, timecost, nf, ng, nR, nH, nV, nVp] = driver_soft_ICA(C, method, params);
        total_timecost = total_timecost + timecost;
        times = times + 1;
    end
    fprintf('average time cost of %d times is %f. \n', times, total_timecost / times);
end
